/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.nullness.quals.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class ElementUtils {
    private ElementUtils() {
        throw new AssertionError((Object)"un-initializable class");
    }

    public static TypeElement enclosingClass(Element elem) {
        Element result = elem;
        while (result != null && !result.getKind().isClass() && !result.getKind().isInterface()) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (TypeElement)result;
    }

    public static PackageElement enclosingPackage(Element elem) {
        Element result = elem;
        while (result != null && result.getKind() != ElementKind.PACKAGE) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (PackageElement)result;
    }

    public static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static TypeMirror getType(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            return ((ExecutableElement)element).getReturnType();
        }
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            return ElementUtils.enclosingClass(element).asType();
        }
        return element.asType();
    }

    @Nullable
    public static Name getQualifiedClassName(Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            PackageElement elem = (PackageElement)element;
            return elem.getQualifiedName();
        }
        TypeElement elem = ElementUtils.enclosingClass(element);
        if (elem == null) {
            return null;
        }
        return elem.getQualifiedName();
    }

    public static boolean isObject(TypeElement element) {
        return element.getQualifiedName().contentEquals("java.lang.Object");
    }

    public static boolean isCompileTimeConstant(Element elt) {
        return elt != null && elt.getKind() == ElementKind.FIELD && ((VariableElement)elt).getConstantValue() != null;
    }
}

