/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.PolymorphicQualifier;
import checkers.types.QualifierHierarchy;
import checkers.util.AnnotationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphQualifierHierarchy
extends QualifierHierarchy {
    private final Map<AnnotationMirror, Set<AnnotationMirror>> supertypesGraph;
    private final Map<AnnotationMirror, Set<AnnotationMirror>> supertypesMap;
    private final AnnotationMirror root;
    private final AnnotationMirror bottom;
    private Set<Name> typeQualifiers = null;
    Map<AnnotationPair, AnnotationMirror> lubs = null;
    Map<AnnotationPair, AnnotationMirror> glbs = null;

    private GraphQualifierHierarchy(Factory f) {
        this.supertypesGraph = f.supertypes;
        this.supertypesMap = GraphQualifierHierarchy.buildFullMap(f.supertypes);
        this.root = GraphQualifierHierarchy.findRoot(this.supertypesMap, null);
        this.bottom = GraphQualifierHierarchy.findBottom(this.supertypesMap, null);
    }

    protected GraphQualifierHierarchy(GraphQualifierHierarchy h) {
        this.supertypesGraph = h.supertypesGraph;
        this.supertypesMap = h.supertypesMap;
        this.root = h.root;
        this.lubs = h.lubs;
        this.bottom = h.bottom;
    }

    @Override
    public AnnotationMirror getRootAnnotation() {
        return this.root;
    }

    @Override
    public AnnotationMirror getBottomQualifier() {
        return this.bottom;
    }

    @Override
    public Set<Name> getTypeQualifiers() {
        if (this.typeQualifiers != null) {
            return this.typeQualifiers;
        }
        HashSet<Name> names = new HashSet<Name>();
        for (AnnotationMirror anno : this.supertypesMap.keySet()) {
            names.add(AnnotationUtils.annotationName(anno));
        }
        this.typeQualifiers = names;
        return this.typeQualifiers;
    }

    @Override
    public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
        if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
            return AnnotationUtils.areSame(a1, a2) ? a1 : this.root;
        }
        if (this.lubs == null) {
            this.lubs = this.calculateLubs();
        }
        AnnotationPair pair = new AnnotationPair(a1, a2);
        return this.lubs.get(pair);
    }

    @Override
    public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
        if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
            return AnnotationUtils.areSame(a1, a2) ? a1 : this.bottom;
        }
        if (this.glbs == null) {
            this.glbs = this.calculateGlbs();
        }
        AnnotationPair pair = new AnnotationPair(a1, a2);
        return this.glbs.get(pair);
    }

    @Override
    public boolean isSubtype(AnnotationMirror anno1, AnnotationMirror anno2) {
        if (AnnotationUtils.areSame(this.root, anno2)) {
            return true;
        }
        if (AnnotationUtils.areSameIgnoringValues(anno1, anno2)) {
            return AnnotationUtils.areSame(anno1, anno2);
        }
        this.checkAnnoInGraph(anno1);
        this.checkAnnoInGraph(anno2);
        return this.supertypesMap.get(anno1).contains(anno2);
    }

    private final void checkAnnoInGraph(AnnotationMirror a) {
        if (this.supertypesMap.containsKey(a)) {
            return;
        }
        if (a == null) {
            throw new IllegalArgumentException("Found an unqualified type.  Please ensure that your implicit rules cover all cases and/or use a @DefaulQualifierInHierarchy annotation");
        }
        throw new IllegalArgumentException("Unrecognized qualifier: " + a);
    }

    private static AnnotationMirror findRoot(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes, AnnotationMirror ignore) {
        LinkedList<AnnotationMirror> possibleRoots = new LinkedList<AnnotationMirror>();
        for (AnnotationMirror anno : supertypes.keySet()) {
            if (!supertypes.get(anno).isEmpty()) continue;
            possibleRoots.add(anno);
        }
        if (ignore != null) {
            possibleRoots.remove(ignore);
        }
        assert (possibleRoots.size() == 1) : "Other than one possible root: " + possibleRoots + "\n" + "Does the checker know about all type qualifiers?";
        return (AnnotationMirror)possibleRoots.get(0);
    }

    private static AnnotationMirror findBottom(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes, AnnotationMirror ignore) {
        Set<AnnotationMirror> bottoms = GraphQualifierHierarchy.findBottoms(supertypes, ignore);
        if (bottoms.size() == 1) {
            return bottoms.iterator().next();
        }
        return null;
    }

    private static Set<AnnotationMirror> findBottoms(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes, AnnotationMirror ignore) {
        Set<AnnotationMirror> bottoms = AnnotationUtils.createAnnotationSet();
        bottoms.addAll(supertypes.keySet());
        for (Set<AnnotationMirror> supers : supertypes.values()) {
            bottoms.removeAll(supers);
        }
        if (ignore != null) {
            bottoms.remove(ignore);
        }
        return bottoms;
    }

    private static Map<AnnotationMirror, Set<AnnotationMirror>> buildFullMap(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
        Map<AnnotationMirror, Set<AnnotationMirror>> fullMap = AnnotationUtils.createAnnotationMap();
        for (AnnotationMirror anno : supertypes.keySet()) {
            GraphQualifierHierarchy.findAllSupers(anno, supertypes, fullMap);
        }
        return fullMap;
    }

    private Map<AnnotationPair, AnnotationMirror> calculateLubs() {
        HashMap<AnnotationPair, AnnotationMirror> newlubs = new HashMap<AnnotationPair, AnnotationMirror>();
        for (AnnotationMirror a1 : this.supertypesGraph.keySet()) {
            for (AnnotationMirror a2 : this.supertypesGraph.keySet()) {
                AnnotationPair pair;
                if (AnnotationUtils.areSameIgnoringValues(a1, a2) || newlubs.containsKey(pair = new AnnotationPair(a1, a2))) continue;
                AnnotationMirror lub = this.findLub(a1, a2);
                newlubs.put(pair, lub);
            }
        }
        return newlubs;
    }

    private AnnotationMirror findLub(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.isSubtype(a1, a2)) {
            return a2;
        }
        if (this.isSubtype(a2, a1)) {
            return a1;
        }
        Set<AnnotationMirror> outset = new HashSet<AnnotationMirror>();
        for (AnnotationMirror a1Super : this.findSmallestTypes(this.supertypesMap.get(a1))) {
            AnnotationMirror a1Lub = this.findLub(a1Super, a2);
            if (a1Lub != null) {
                outset.add(a1Lub);
            }
            if (a1Lub != null || a1Super != null) continue;
            outset.add(null);
        }
        if (outset.size() == 1) {
            return (AnnotationMirror)outset.iterator().next();
        }
        if (outset.size() > 1) {
            outset = this.findSmallestTypes(outset);
            return outset.iterator().next();
        }
        throw new AssertionError((Object)("Could not determine LUB for " + a1 + " and " + a2 + "\n" + "Does the checker know about all type qualifiers?"));
    }

    private Set<AnnotationMirror> findSmallestTypes(Set<AnnotationMirror> inset) {
        HashSet<AnnotationMirror> outset = new HashSet<AnnotationMirror>(inset);
        for (AnnotationMirror a1 : inset) {
            Iterator outit = outset.iterator();
            while (outit.hasNext()) {
                AnnotationMirror a2 = (AnnotationMirror)outit.next();
                if (a1 == a2 || !this.isSubtype(a1, a2)) continue;
                outit.remove();
            }
        }
        return outset;
    }

    private static Set<AnnotationMirror> findAllSupers(AnnotationMirror anno, Map<AnnotationMirror, Set<AnnotationMirror>> supertypes, Map<AnnotationMirror, Set<AnnotationMirror>> allSupersSoFar) {
        Set<AnnotationMirror> supers = AnnotationUtils.createAnnotationSet();
        if (allSupersSoFar.containsKey(anno)) {
            return Collections.unmodifiableSet(allSupersSoFar.get(anno));
        }
        for (AnnotationMirror superAnno : supertypes.get(anno)) {
            supers.add(superAnno);
            supers.addAll(GraphQualifierHierarchy.findAllSupers(superAnno, supertypes, allSupersSoFar));
        }
        allSupersSoFar.put(anno, Collections.unmodifiableSet(supers));
        return supers;
    }

    private Map<AnnotationPair, AnnotationMirror> calculateGlbs() {
        HashMap<AnnotationPair, AnnotationMirror> newglbs = new HashMap<AnnotationPair, AnnotationMirror>();
        for (AnnotationMirror a1 : this.supertypesGraph.keySet()) {
            for (AnnotationMirror a2 : this.supertypesGraph.keySet()) {
                AnnotationPair pair;
                if (AnnotationUtils.areSameIgnoringValues(a1, a2) || newglbs.containsKey(pair = new AnnotationPair(a1, a2))) continue;
                AnnotationMirror glb = this.findGlb(a1, a2);
                newglbs.put(pair, glb);
            }
        }
        return newglbs;
    }

    private AnnotationMirror findGlb(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.isSubtype(a1, a2)) {
            return a1;
        }
        if (this.isSubtype(a2, a1)) {
            return a2;
        }
        Set<AnnotationMirror> outset = new HashSet<AnnotationMirror>();
        for (AnnotationMirror a1Sub : this.supertypesGraph.keySet()) {
            AnnotationMirror a1lb;
            if (!this.isSubtype(a1Sub, a1) || a1Sub.equals(a1) || (a1lb = this.findGlb(a1Sub, a2)) == null) continue;
            outset.add(a1lb);
        }
        if (outset.size() == 1) {
            return (AnnotationMirror)outset.iterator().next();
        }
        if (outset.size() > 1) {
            outset = this.findGreatestTypes(outset);
            return outset.iterator().next();
        }
        throw new AssertionError((Object)("Could not determine GLB for " + a1 + " and " + a2 + "\n" + "Does the checker know about all type qualifiers?"));
    }

    private Set<AnnotationMirror> findGreatestTypes(Set<AnnotationMirror> inset) {
        HashSet<AnnotationMirror> outset = new HashSet<AnnotationMirror>(inset);
        for (AnnotationMirror a1 : inset) {
            Iterator outit = outset.iterator();
            while (outit.hasNext()) {
                AnnotationMirror a2 = (AnnotationMirror)outit.next();
                if (a1 == a2 || !this.isSubtype(a2, a1)) continue;
                outit.remove();
            }
        }
        return outset;
    }

    private static class AnnotationPair {
        public final AnnotationMirror a1;
        public final AnnotationMirror a2;
        private int hashCode = -1;

        public AnnotationPair(AnnotationMirror a1, AnnotationMirror a2) {
            this.a1 = a1;
            this.a2 = a2;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = 31;
                if (this.a1 != null) {
                    this.hashCode += 17 * this.a1.toString().hashCode();
                }
                if (this.a2 != null) {
                    this.hashCode += 17 * this.a2.toString().hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationPair)) {
                return false;
            }
            AnnotationPair other = (AnnotationPair)o;
            if (AnnotationUtils.areSameIgnoringValues(this.a1, other.a1) && AnnotationUtils.areSameIgnoringValues(this.a2, other.a2)) {
                return true;
            }
            return AnnotationUtils.areSameIgnoringValues(this.a2, other.a1) && AnnotationUtils.areSameIgnoringValues(this.a1, other.a2);
        }
    }

    public static class Factory {
        private Map<AnnotationMirror, Set<AnnotationMirror>> supertypes = AnnotationUtils.createAnnotationMap();
        private AnnotationMirror polyQualifier;
        private boolean wasBuilt = false;

        public void addQualifier(AnnotationMirror qual) {
            this.assertNotBuilt();
            if (this.supertypes.containsKey(qual)) {
                return;
            }
            this.supertypes.put(qual, AnnotationUtils.createAnnotationSet());
            if (this.isPolymorphic(qual)) {
                this.polyQualifier = qual;
            }
        }

        private boolean isPolymorphic(AnnotationMirror qual) {
            if (qual == null) {
                return false;
            }
            Element qualElt = qual.getAnnotationType().asElement();
            return qualElt.getAnnotation(PolymorphicQualifier.class) != null;
        }

        public void addSubtype(AnnotationMirror sub, AnnotationMirror sup) {
            this.assertNotBuilt();
            this.addQualifier(sub);
            this.addQualifier(sup);
            this.supertypes.get(sub).add(sup);
        }

        public GraphQualifierHierarchy build() {
            this.assertNotBuilt();
            this.addPolyRelations();
            this.wasBuilt = true;
            return new GraphQualifierHierarchy(this);
        }

        private void assertNotBuilt() {
            if (this.wasBuilt) {
                throw new IllegalStateException("qualifier hierarchy already built");
            }
        }

        private void addPolyRelations() {
            if (this.polyQualifier == null) {
                return;
            }
            if (this.supertypes.get(this.polyQualifier).isEmpty()) {
                AnnotationMirror root = GraphQualifierHierarchy.findRoot(this.supertypes, this.polyQualifier);
                this.addSubtype(this.polyQualifier, root);
            }
            Set bottoms = GraphQualifierHierarchy.findBottoms(this.supertypes, this.polyQualifier);
            for (AnnotationMirror bottom : bottoms) {
                this.addSubtype(bottom, this.polyQualifier);
            }
        }
    }
}

