/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.nullness.quals.Nullable;
import checkers.util.TreeUtils;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUtils {
    private static final boolean RETURN_INVOKE_CONSTRUCTOR = true;

    private InternalUtils() {
    }

    @Nullable
    public static Element symbol(@Nullable Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("tree is null");
        }
        if (!(tree instanceof JCTree)) {
            throw new IllegalArgumentException("tree is not a valid Javac tree");
        }
        tree = TreeUtils.skipParens(tree);
        switch (tree.getKind()) {
            case VARIABLE: 
            case METHOD: 
            case CLASS: {
                return TreeInfo.symbolFor((JCTree)tree);
            }
            case METHOD_INVOCATION: {
                return TreeInfo.symbol(((JCTree.JCMethodInvocation)tree).getMethodSelect());
            }
            case ASSIGNMENT: {
                return TreeInfo.symbol((JCTree)((Object)((AssignmentTree)tree).getVariable()));
            }
            case ARRAY_ACCESS: {
                return InternalUtils.symbol(((ArrayAccessTree)tree).getExpression());
            }
        }
        return TreeInfo.symbol((JCTree)tree);
    }

    public static boolean isAnonymousConstructor(MethodTree method) {
        Element e = InternalUtils.symbol(method);
        if (e == null || !(e instanceof Symbol)) {
            return false;
        }
        return (((Symbol)e).flags() & 0x20000000L) != 0L;
    }

    public static ExecutableElement constructor(NewClassTree tree) {
        if (!(tree instanceof JCTree.JCNewClass)) {
            throw new IllegalArgumentException("not a javac internal tree");
        }
        JCTree.JCNewClass newClassTree = (JCTree.JCNewClass)tree;
        if (tree.getClassBody() != null) {
            JCTree.JCMethodDecl anonConstructor = (JCTree.JCMethodDecl)TreeInfo.declarationFor(newClassTree.constructor, newClassTree);
            assert (anonConstructor != null);
            assert (anonConstructor.body.stats.size() == 1);
            JCTree.JCExpressionStatement stmt = (JCTree.JCExpressionStatement)anonConstructor.body.stats.head;
            JCTree.JCMethodInvocation superInvok = (JCTree.JCMethodInvocation)stmt.expr;
            return (ExecutableElement)((Object)TreeInfo.symbol(superInvok.meth));
        }
        Symbol e = newClassTree.constructor;
        assert (e instanceof ExecutableElement);
        return (ExecutableElement)((Object)e);
    }

    public static final List<AnnotationMirror> annotationsFromTypeAnnotationTrees(List<? extends AnnotationTree> annos) {
        ArrayList<AnnotationMirror> annotations = new ArrayList<AnnotationMirror>(annos.size());
        for (AnnotationTree annotationTree : annos) {
            annotations.add(((JCTree.JCTypeAnnotation)annotationTree).attribute_field);
        }
        return annotations;
    }

    public static final List<? extends AnnotationMirror> annotationsFromTree(AnnotatedTypeTree node) {
        return InternalUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCAnnotatedType)node).annotations);
    }

    public static final List<? extends AnnotationMirror> annotationsFromTree(TypeParameterTree node) {
        return InternalUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCTypeParameter)node).annotations);
    }

    public static final List<? extends AnnotationMirror> annotationsFromArrayCreation(NewArrayTree node, int level) {
        assert (node instanceof JCTree.JCNewArray);
        JCTree.JCNewArray newArray = (JCTree.JCNewArray)node;
        if (level == -1) {
            return InternalUtils.annotationsFromTypeAnnotationTrees(newArray.annotations);
        }
        if (newArray.dimAnnotations.length() > 0 && level >= 0 && level < newArray.dimAnnotations.size()) {
            return InternalUtils.annotationsFromTypeAnnotationTrees((List<? extends AnnotationTree>)newArray.dimAnnotations.get(level));
        }
        return Collections.emptyList();
    }

    public static TypeMirror typeOf(Tree tree) {
        return ((JCTree)tree).type;
    }
}

