/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.debug;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
public class TreeDebug
extends AbstractProcessor {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected Visitor createSourceVisitor(CompilationUnitTree root) {
        return new Visitor();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement element : ElementFilter.typesIn(roundEnv.getRootElements())) {
            TreePath path = Trees.instance(this.processingEnv).getPath(element);
            new Visitor().scan(path, null);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Visitor
    extends TreePathScanner<Void, Void> {
        private StringBuffer buf = new StringBuffer();

        @Override
        public Void scan(Tree node, Void p) {
            if (this.getCurrentPath() != null) {
                for (TreePath tp = this.getCurrentPath(); tp != null; tp = tp.getParentPath()) {
                    this.buf.append("  ");
                }
            }
            if (node == null) {
                this.buf.append("null");
            } else {
                this.buf.append((Object)node.getKind());
            }
            this.buf.append(LINE_SEPARATOR);
            super.scan(node, p);
            System.out.print(this.buf.toString());
            this.buf.setLength(0);
            return null;
        }

        private final void insert(Object text) {
            this.buf.insert(this.buf.length() - 1, " ");
            this.buf.insert(this.buf.length() - 1, text);
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            this.insert(node);
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            this.insert(node.getExpression() + "." + node.getIdentifier());
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitNewArray(NewArrayTree node, Void p) {
            this.insert(((JCTree.JCNewArray)node).annotations);
            this.insert("|");
            this.insert(((JCTree.JCNewArray)node).dimAnnotations);
            return (Void)super.visitNewArray(node, p);
        }

        @Override
        public Void visitLiteral(LiteralTree node, Void p) {
            this.insert(node.getValue());
            return (Void)super.visitLiteral(node, p);
        }
    }
}

