/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.stub;

import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.AnnotationUtils;
import checkers.util.stub.StubUtil;
import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.IndexUnit;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.WildcardType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubParser {
    public static boolean warnIfNotFound = false;
    public static boolean debugStubParser = false;
    final String filename;
    final IndexUnit index;
    final AnnotatedTypeFactory atypeFactory;
    final AnnotationUtils annoUtils;
    final ProcessingEnvironment env;
    final Elements elements;
    final Map<String, AnnotationMirror> annotations;
    static Set<String> nestedClassWarnings = new HashSet<String>();

    public StubParser(String filename, InputStream inputStream, AnnotatedTypeFactory factory, ProcessingEnvironment env) {
        this.filename = filename;
        try {
            this.index = JavaParser.parse(inputStream);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        this.atypeFactory = factory;
        this.env = env;
        this.annoUtils = AnnotationUtils.getInstance(env);
        this.elements = env.getElementUtils();
        this.annotations = this.getSupportedAnnotations();
    }

    private Map<String, AnnotationMirror> annoWithinPackage(String packageName) {
        AnnotationUtils annoUtils = AnnotationUtils.getInstance(this.env);
        HashMap<String, AnnotationMirror> r = new HashMap<String, AnnotationMirror>();
        PackageElement pkg = this.elements.getPackageElement(packageName);
        if (pkg == null) {
            return r;
        }
        for (TypeElement typeElm : ElementFilter.typesIn(pkg.getEnclosedElements())) {
            if (typeElm.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            AnnotationMirror anno = annoUtils.fromName(typeElm.getQualifiedName());
            r.put(typeElm.getSimpleName().toString(), anno);
        }
        return r;
    }

    private Map<String, AnnotationMirror> getSupportedAnnotations() {
        assert (!this.index.getCompilationUnits().isEmpty());
        CompilationUnit cu = this.index.getCompilationUnits().get(0);
        AnnotationUtils annoUtils = AnnotationUtils.getInstance(this.env);
        HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
        if (cu.getImports() == null) {
            return result;
        }
        for (ImportDeclaration importDecl : cu.getImports()) {
            String imported = importDecl.getName().toString();
            try {
                if (!importDecl.isAsterisk()) {
                    AnnotationMirror anno = annoUtils.fromName(imported);
                    if (anno != null) {
                        Element annoElt = anno.getAnnotationType().asElement();
                        result.put(annoElt.getSimpleName().toString(), anno);
                        continue;
                    }
                    if (!warnIfNotFound && !debugStubParser) continue;
                    System.err.println("StubParser: Could not load import: " + imported);
                    continue;
                }
                result.putAll(this.annoWithinPackage(imported));
            }
            catch (AssertionError error) {
                System.err.println("StubParser: " + error);
            }
        }
        return result;
    }

    public Map<Element, AnnotatedTypeMirror> parse() {
        HashMap<Element, AnnotatedTypeMirror> result = new HashMap<Element, AnnotatedTypeMirror>();
        this.parse(result);
        return result;
    }

    public void parse(Map<Element, AnnotatedTypeMirror> result) {
        this.parse(this.index, result);
    }

    private void parse(IndexUnit index, Map<Element, AnnotatedTypeMirror> result) {
        for (CompilationUnit cu : index.getCompilationUnits()) {
            this.parse(cu, result);
        }
    }

    private void parse(CompilationUnit cu, Map<Element, AnnotatedTypeMirror> result) {
        String packageName = cu.getPackage() == null ? null : cu.getPackage().getName().toString();
        if (cu.getTypes() != null) {
            for (TypeDeclaration typeDecl : cu.getTypes()) {
                this.parse(typeDecl, packageName, result);
            }
        }
    }

    private void parse(TypeDeclaration typeDecl, String packageName, Map<Element, AnnotatedTypeMirror> result) {
        String typeName = (packageName == null ? "" : packageName + ".") + typeDecl.getName().replace('$', '.');
        TypeElement typeElt = this.elements.getTypeElement(typeName);
        if (typeElt == null) {
            if (warnIfNotFound || debugStubParser) {
                System.err.println("StubParser: Type not found: " + typeName);
            }
            return;
        }
        if ((typeElt.getKind() == ElementKind.ENUM || typeElt.getKind() == ElementKind.ANNOTATION_TYPE) && (warnIfNotFound || debugStubParser)) {
            System.err.println("StubParser: Skipping enum or annotation type: " + typeName);
        }
        if (typeDecl instanceof ClassOrInterfaceDeclaration) {
            this.parseType((ClassOrInterfaceDeclaration)typeDecl, typeElt, result);
        }
        Map<Element, BodyDeclaration> elementsToDecl = this.mapMembers(typeElt, typeDecl);
        for (Map.Entry<Element, BodyDeclaration> entry : elementsToDecl.entrySet()) {
            Element elt = entry.getKey();
            BodyDeclaration decl = entry.getValue();
            if (elt.getKind().isField()) {
                this.parseField((FieldDeclaration)decl, (VariableElement)elt, result);
                continue;
            }
            if (elt.getKind() == ElementKind.CONSTRUCTOR) {
                this.parseConstructor((ConstructorDeclaration)decl, (ExecutableElement)elt, result);
                continue;
            }
            if (elt.getKind() == ElementKind.METHOD) {
                this.parseMethod((MethodDeclaration)decl, (ExecutableElement)elt, result);
                continue;
            }
            System.err.println("Ignoring: " + elt);
        }
    }

    private void parseType(ClassOrInterfaceDeclaration decl, TypeElement elt, Map<Element, AnnotatedTypeMirror> result) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.fromElement(elt);
        this.annotate((AnnotatedTypeMirror)type, decl.getAnnotations());
        this.annotateParameters(type.getTypeArguments(), decl.getTypeParameters());
        this.annotateSupertypes(decl, type);
        result.put(elt, type);
    }

    private void annotateSupertypes(ClassOrInterfaceDeclaration typeDecl, AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedDeclaredType foundType;
        if (typeDecl.getExtends() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getExtends()) {
                foundType = this.findType(superType, type.directSuperTypes());
                assert (foundType != null);
                if (foundType == null) continue;
                this.annotate((AnnotatedTypeMirror)foundType, superType);
            }
        }
        if (typeDecl.getImplements() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getImplements()) {
                foundType = this.findType(superType, type.directSuperTypes());
                assert (foundType != null);
                if (foundType == null) continue;
                this.annotate((AnnotatedTypeMirror)foundType, superType);
            }
        }
    }

    private void parseMethod(MethodDeclaration decl, ExecutableElement elt, Map<Element, AnnotatedTypeMirror> result) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        this.annotateParameters(methodType.getTypeVariables(), decl.getTypeParameters());
        this.annotate(methodType.getReturnType(), decl.getType());
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            AnnotatedTypeMirror paramType = methodType.getParameterTypes().get(i);
            Parameter param = decl.getParameters().get(i);
            if (param.isVarArgs()) {
                assert (paramType.getKind() == TypeKind.ARRAY);
                this.annotate(((AnnotatedTypeMirror.AnnotatedArrayType)paramType).getComponentType(), param.getType());
                continue;
            }
            this.annotate(paramType, param.getType());
        }
        this.annotate((AnnotatedTypeMirror)methodType.getReceiverType(), decl.getReceiverAnnotations());
        result.put(elt, methodType);
    }

    private List<AnnotatedTypeMirror> arrayList(AnnotatedTypeMirror.AnnotatedArrayType atype) {
        LinkedList<AnnotatedTypeMirror> arrays = new LinkedList<AnnotatedTypeMirror>();
        AnnotatedTypeMirror type = atype;
        while (type.getKind() == TypeKind.ARRAY) {
            arrays.addFirst(type);
            type = type.getComponentType();
        }
        arrays.add(type);
        return arrays;
    }

    private void annotateAsArray(AnnotatedTypeMirror.AnnotatedArrayType atype, ReferenceType typeDef) {
        List<AnnotatedTypeMirror> arrayTypes = this.arrayList(atype);
        assert (typeDef.getArrayCount() == arrayTypes.size() - 1);
        for (int i = 0; i < typeDef.getArrayCount(); ++i) {
            List<AnnotationExpr> annotations = typeDef.getAnnotationsAtLevel(i);
            if (annotations == null) continue;
            this.annotate(arrayTypes.get(i), annotations);
        }
        this.annotate(arrayTypes.get(arrayTypes.size() - 1), typeDef.getAnnotations());
    }

    private ClassOrInterfaceType unwrapDeclaredType(Type type) {
        if (type instanceof ClassOrInterfaceType) {
            return (ClassOrInterfaceType)type;
        }
        if (type instanceof ReferenceType && ((ReferenceType)type).getArrayCount() == 0) {
            return this.unwrapDeclaredType(((ReferenceType)type).getType());
        }
        return null;
    }

    private void annotate(AnnotatedTypeMirror atype, Type typeDef) {
        if (atype.getKind() == TypeKind.ARRAY) {
            this.annotateAsArray((AnnotatedTypeMirror.AnnotatedArrayType)atype, (ReferenceType)typeDef);
            return;
        }
        if (typeDef.getAnnotations() != null) {
            this.annotate(atype, typeDef.getAnnotations());
        }
        ClassOrInterfaceType declType = this.unwrapDeclaredType(typeDef);
        if (atype.getKind() == TypeKind.DECLARED && declType != null) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adeclType = (AnnotatedTypeMirror.AnnotatedDeclaredType)atype;
            if (declType.getTypeArgs() != null && !declType.getTypeArgs().isEmpty() && adeclType.isParameterized()) {
                assert (declType.getTypeArgs().size() == adeclType.getTypeArguments().size());
                for (int i = 0; i < declType.getTypeArgs().size(); ++i) {
                    this.annotate(adeclType.getTypeArguments().get(i), declType.getTypeArgs().get(i));
                }
            }
        } else if (atype.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)atype;
            WildcardType wildcardDef = (WildcardType)typeDef;
            if (wildcardDef.getExtends() != null) {
                this.annotate(wildcardType.getExtendsBound(), wildcardDef.getExtends());
            } else if (wildcardDef.getSuper() != null) {
                this.annotate(wildcardType.getSuperBound(), wildcardDef.getSuper());
            }
        }
    }

    private void parseConstructor(ConstructorDeclaration decl, ExecutableElement elt, Map<Element, AnnotatedTypeMirror> result) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            AnnotatedTypeMirror paramType = methodType.getParameterTypes().get(i);
            Parameter param = decl.getParameters().get(i);
            this.annotate(paramType, param.getType());
        }
        this.annotate((AnnotatedTypeMirror)methodType.getReceiverType(), decl.getReceiverAnnotations());
        result.put(elt, methodType);
    }

    private void parseField(FieldDeclaration decl, VariableElement elt, Map<Element, AnnotatedTypeMirror> result) {
        AnnotatedTypeMirror fieldType = this.atypeFactory.fromElement(elt);
        this.annotate(fieldType, decl.getType());
        result.put(elt, fieldType);
    }

    private void annotate(AnnotatedTypeMirror type, List<AnnotationExpr> annotations) {
        if (annotations == null) {
            return;
        }
        for (AnnotationExpr annotation : annotations) {
            String annoName = StubUtil.getAnnotationName(annotation);
            AnnotationMirror annoMirror = this.annotations.get(annoName);
            if (annoMirror == null) continue;
            type.addAnnotation(annoMirror);
        }
    }

    private void annotateParameters(List<? extends AnnotatedTypeMirror> typeArguments, List<TypeParameter> typeParameters) {
        if (typeParameters == null) {
            return;
        }
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameter param = typeParameters.get(i);
            AnnotatedTypeMirror.AnnotatedTypeVariable paramType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeArguments.get(i);
            if (param.getTypeBound() == null || param.getTypeBound().size() != 1) continue;
            this.annotate(paramType.getUpperBound(), param.getTypeBound().get(0));
        }
    }

    private Map<Element, BodyDeclaration> mapMembers(TypeElement typeElt, TypeDeclaration typeDecl) {
        assert (typeElt.getSimpleName().contentEquals(typeDecl.getName()) || typeDecl.getName().endsWith("$" + typeElt.getSimpleName().toString())) : String.format("%s  %s", typeElt.getSimpleName(), typeDecl.getName());
        HashMap<Element, BodyDeclaration> result = new HashMap<Element, BodyDeclaration>();
        for (BodyDeclaration member : typeDecl.getMembers()) {
            ExecutableElement elt;
            if (member instanceof MethodDeclaration) {
                elt = this.findElement(typeElt, (MethodDeclaration)member);
                result.put(elt, member);
                continue;
            }
            if (member instanceof ConstructorDeclaration) {
                elt = this.findElement(typeElt, (ConstructorDeclaration)member);
                result.put(elt, member);
                continue;
            }
            if (member instanceof FieldDeclaration) {
                FieldDeclaration fieldDecl = (FieldDeclaration)member;
                for (VariableDeclarator var : fieldDecl.getVariables()) {
                    result.put(this.findElement(typeElt, var), fieldDecl);
                }
                continue;
            }
            if (member instanceof ClassOrInterfaceDeclaration) {
                ClassOrInterfaceDeclaration ciDecl = (ClassOrInterfaceDeclaration)member;
                String nestedClass = typeDecl.getName() + "." + ciDecl.getName();
                if (!nestedClassWarnings.add(nestedClass)) continue;
                System.err.printf("Warning: ignoring nested class in %s at line %d:%n    class %s { class %s { ... } }%n", this.filename, ciDecl.getBeginLine(), typeDecl.getName(), ciDecl.getName());
                System.err.printf("  Instead, write the nested class as a top-level class:%n    class %s { ... }%n    class %s$%s { ... }%n", typeDecl.getName(), typeDecl.getName(), ciDecl.getName());
                continue;
            }
            if (!warnIfNotFound && !debugStubParser) continue;
            System.out.printf("StubParser: Ignoring element of type %s in mapMembers", member.getClass());
        }
        result.remove(null);
        return result;
    }

    private AnnotatedTypeMirror.AnnotatedDeclaredType findType(ClassOrInterfaceType type, List<AnnotatedTypeMirror.AnnotatedDeclaredType> types) {
        String typeString = type.getName();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
            if (!superType.getUnderlyingType().asElement().getSimpleName().contentEquals(typeString)) continue;
            return superType;
        }
        if (warnIfNotFound || debugStubParser) {
            System.err.println("StubParser: Type " + typeString + " not found");
        }
        if (debugStubParser) {
            for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
                System.err.printf("  %s%n", superType);
            }
        }
        return null;
    }

    public ExecutableElement findElement(TypeElement typeElt, MethodDeclaration methodDecl) {
        String wantedMethodName = methodDecl.getName();
        int wantedMethodParams = methodDecl.getParameters() == null ? 0 : methodDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(methodDecl);
        for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (wantedMethodParams != method.getParameters().size() || !wantedMethodName.contentEquals(method.getSimpleName()) || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        if (warnIfNotFound || debugStubParser) {
            System.err.println("StubParser: Method " + wantedMethodString + " not found in type " + typeElt);
        }
        if (debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                System.err.printf("  %s%n", method);
            }
        }
        return null;
    }

    public ExecutableElement findElement(TypeElement typeElt, ConstructorDeclaration methodDecl) {
        int wantedMethodParams = methodDecl.getParameters() == null ? 0 : methodDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(methodDecl);
        for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
            if (wantedMethodParams != method.getParameters().size() || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        if (warnIfNotFound || debugStubParser) {
            System.err.println("StubParser: Constructor " + wantedMethodString + " not found in type " + typeElt);
        }
        if (debugStubParser) {
            for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
                System.err.printf("  %s%n", method);
            }
        }
        return null;
    }

    public VariableElement findElement(TypeElement typeElt, VariableDeclarator variable) {
        String fieldName = variable.getId().getName();
        for (VariableElement field : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
            if (!fieldName.contains(field.getSimpleName())) continue;
            return field;
        }
        if (warnIfNotFound || debugStubParser) {
            System.err.println("StubParser: Field " + fieldName + " not found in type " + typeElt);
        }
        if (debugStubParser) {
            for (VariableElement field : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                System.err.printf("  %s%n", field);
            }
        }
        return null;
    }
}

