/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.stub;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.IndexUnit;
import japa.parser.ast.Node;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.SimpleVoidVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubUtil {
    static TypeDeclaration findDeclaration(String className, IndexUnit indexFile) {
        int indexOfDot = className.lastIndexOf(46);
        if (indexOfDot == -1) {
            assert (!indexFile.getCompilationUnits().isEmpty());
            assert (indexFile.getCompilationUnits().get(0).getPackage() == null);
            return StubUtil.findDeclaration(className, indexFile.getCompilationUnits().get(0));
        }
        String packageName = className.substring(0, indexOfDot);
        String simpleName = className.substring(indexOfDot + 1);
        for (CompilationUnit cu : indexFile.getCompilationUnits()) {
            TypeDeclaration type;
            if (cu.getPackage() == null || !cu.getPackage().getName().getName().equals(packageName) || (type = StubUtil.findDeclaration(simpleName, cu)) == null) continue;
            return type;
        }
        return null;
    }

    static TypeDeclaration findDeclaration(TypeElement type, IndexUnit indexFile) {
        return StubUtil.findDeclaration(type.getQualifiedName().toString(), indexFile);
    }

    static FieldDeclaration findDeclaration(VariableElement field, IndexUnit indexFile) {
        TypeDeclaration type = StubUtil.findDeclaration((TypeElement)field.getEnclosingElement(), indexFile);
        if (type == null) {
            return null;
        }
        for (BodyDeclaration member : type.getMembers()) {
            if (!(member instanceof FieldDeclaration)) continue;
            FieldDeclaration decl = (FieldDeclaration)member;
            for (VariableDeclarator var : decl.getVariables()) {
                if (!StubUtil.toString(var).equals(field.getSimpleName().toString())) continue;
                return decl;
            }
        }
        return null;
    }

    static BodyDeclaration findDeclaration(ExecutableElement method, IndexUnit indexFile) {
        TypeDeclaration type = StubUtil.findDeclaration((TypeElement)method.getEnclosingElement(), indexFile);
        if (type == null) {
            return null;
        }
        String methodRep = StubUtil.toString(method);
        for (BodyDeclaration member : type.getMembers()) {
            if (!(member instanceof MethodDeclaration ? StubUtil.toString((MethodDeclaration)member).equals(methodRep) : member instanceof ConstructorDeclaration && StubUtil.toString((ConstructorDeclaration)member).equals(methodRep))) continue;
            return member;
        }
        return null;
    }

    static TypeDeclaration findDeclaration(String simpleName, CompilationUnit cu) {
        for (TypeDeclaration type : cu.getTypes()) {
            if (!simpleName.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    static String toString(MethodDeclaration method) {
        return ElementPrinter.toString(method);
    }

    static String toString(ConstructorDeclaration constructor) {
        return ElementPrinter.toString(constructor);
    }

    static String toString(VariableDeclarator field) {
        return field.getId().getName();
    }

    static String toString(FieldDeclaration field) {
        assert (field.getVariables().size() == 1);
        return StubUtil.toString(field.getVariables().get(0));
    }

    static String toString(ExecutableElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getSimpleName());
        sb.append("(");
        Iterator<? extends VariableElement> i = element.getParameters().iterator();
        while (i.hasNext()) {
            sb.append(StubUtil.standarizeType(i.next().asType()));
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    static String toString(VariableElement element) {
        assert (element.getKind().isField());
        return element.getSimpleName().toString();
    }

    static String toString(Element element) {
        if (element instanceof ExecutableElement) {
            return StubUtil.toString((ExecutableElement)element);
        }
        if (element instanceof VariableElement) {
            return StubUtil.toString((VariableElement)element);
        }
        return null;
    }

    private static String standarizeType(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return StubUtil.standarizeType(((ArrayType)type).getComponentType()) + "[]";
            }
            case TYPEVAR: {
                return ((TypeVariable)type).asElement().getSimpleName().toString();
            }
            case DECLARED: {
                return ((DeclaredType)type).asElement().getSimpleName().toString();
            }
        }
        if (type.getKind().isPrimitive()) {
            return type.toString();
        }
        throw new IllegalStateException("Unhandled type");
    }

    static String getAnnotationName(AnnotationExpr annotation) {
        if (annotation instanceof MarkerAnnotationExpr) {
            return ((MarkerAnnotationExpr)annotation).getName().getName();
        }
        if (annotation instanceof NormalAnnotationExpr) {
            return ((NormalAnnotationExpr)annotation).getName().getName();
        }
        if (annotation instanceof SingleMemberAnnotationExpr) {
            return ((SingleMemberAnnotationExpr)annotation).getName().getName();
        }
        throw new AssertionError((Object)("unknown annotation type: " + annotation));
    }

    public static List<File> allStubFiles(String stub) {
        ArrayList<File> files = new ArrayList<File>();
        File stubFile = new File(stub);
        StubUtil.allStubFiles(stubFile, files);
        return files;
    }

    private static boolean isStub(File f) {
        return f.isFile() && f.getName().endsWith(".astub");
    }

    private static void allStubFiles(File stub, List<File> files) {
        if (StubUtil.isStub(stub)) {
            files.add(stub);
        } else if (stub.isDirectory()) {
            for (File enclosed : stub.listFiles()) {
                if (StubUtil.isStub(enclosed)) {
                    files.add(enclosed);
                    continue;
                }
                if (!enclosed.isDirectory()) continue;
                StubUtil.allStubFiles(enclosed, files);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementPrinter
    extends SimpleVoidVisitor<Void> {
        private StringBuilder sb = new StringBuilder();

        private ElementPrinter() {
        }

        public static String toString(Node n) {
            ElementPrinter printer = new ElementPrinter();
            n.accept(printer, null);
            return printer.getOutput();
        }

        public String getOutput() {
            return this.sb.toString();
        }

        @Override
        public void visit(ConstructorDeclaration n, Void arg) {
            this.sb.append("<init>");
            this.sb.append("(");
            if (n.getParameters() != null) {
                Iterator<Parameter> i = n.getParameters().iterator();
                while (i.hasNext()) {
                    Parameter p = i.next();
                    p.accept(this, arg);
                    if (!i.hasNext()) continue;
                    this.sb.append(",");
                }
            }
            this.sb.append(")");
        }

        @Override
        public void visit(MethodDeclaration n, Void arg) {
            this.sb.append(n.getName());
            this.sb.append("(");
            if (n.getParameters() != null) {
                Iterator<Parameter> i = n.getParameters().iterator();
                while (i.hasNext()) {
                    Parameter p = i.next();
                    p.accept(this, arg);
                    if (p.isVarArgs()) {
                        this.sb.append("[]");
                    }
                    if (!i.hasNext()) continue;
                    this.sb.append(",");
                }
            }
            this.sb.append(")");
        }

        @Override
        public void visit(Parameter n, Void arg) {
            n.getType().accept(this, arg);
        }

        @Override
        public void visit(ClassOrInterfaceType n, Void arg) {
            this.sb.append(n.getName());
        }

        @Override
        public void visit(PrimitiveType n, Void arg) {
            switch (n.getType()) {
                case Boolean: {
                    this.sb.append("boolean");
                    break;
                }
                case Byte: {
                    this.sb.append("byte");
                    break;
                }
                case Char: {
                    this.sb.append("char");
                    break;
                }
                case Double: {
                    this.sb.append("double");
                    break;
                }
                case Float: {
                    this.sb.append("float");
                    break;
                }
                case Int: {
                    this.sb.append("int");
                    break;
                }
                case Long: {
                    this.sb.append("long");
                    break;
                }
                case Short: {
                    this.sb.append("short");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)n.getType()));
                }
            }
        }

        @Override
        public void visit(ReferenceType n, Void arg) {
            n.getType().accept(this, arg);
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.sb.append("[]");
            }
        }

        @Override
        public void visit(VoidType n, Void arg) {
            this.sb.append("void");
        }

        @Override
        public void visit(WildcardType n, Void arg) {
            throw new IllegalStateException("don't print type args!");
        }
    }
}

