/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.test;

import checkers.source.Result;
import checkers.source.SourceChecker;
import checkers.source.SourceVisitor;
import checkers.types.AnnotatedTypeFactory;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedOptions(value={"checker"})
public class FactoryTestChecker
extends SourceChecker {
    SourceChecker checker;

    @Override
    public synchronized void init(ProcessingEnvironment p) {
        super.init(p);
        String checkerClassName = this.env.getOptions().get("checker");
        try {
            Class<?> checkerClass;
            Constructor<?> constructor;
            Object o;
            if (checkerClassName != null && (o = (constructor = (checkerClass = Class.forName(checkerClassName)).getConstructor(new Class[0])).newInstance(new Object[0])) instanceof SourceChecker) {
                this.checker = (SourceChecker)o;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't load " + checkerClassName + " class.");
        }
    }

    @Override
    public AnnotatedTypeFactory createFactory(CompilationUnitTree root) {
        return this.checker.createFactory(root);
    }

    @Override
    public Properties getMessages() {
        Properties prop = new Properties();
        prop.setProperty("type.unexpected", "unexpected type for the given tree\nTree       : %s\nFound      : %s\nExpected   : %s\n");
        return prop;
    }

    protected SourceVisitor<Void, Void> createSourceVisitor(CompilationUnitTree root) {
        return new ToStringVisitor(this, root);
    }

    private Map<TreeSpec, String> buildExpected(CompilationUnitTree tree) {
        HashMap<TreeSpec, String> expected = new HashMap<TreeSpec, String>();
        try {
            JavaFileObject o = tree.getSourceFile();
            File sourceFile = new File(o.toUri());
            LineNumberReader reader = new LineNumberReader(new FileReader(sourceFile));
            String line = reader.readLine();
            Pattern prevsubtreePattern = Pattern.compile("\\s*///(.*)-:-(.*)");
            Pattern prevfulltreePattern = Pattern.compile("\\s*///(.*)");
            Pattern subtreePattern = Pattern.compile("(.*)///(.*)-:-(.*)");
            Pattern fulltreePattern = Pattern.compile("(.*)///(.*)");
            while (line != null) {
                TreeSpec treeSpec;
                String treeString;
                Matcher prevsubtreeMatcher = prevsubtreePattern.matcher(line);
                Matcher prevfulltreeMatcher = prevfulltreePattern.matcher(line);
                Matcher subtreeMatcher = subtreePattern.matcher(line);
                Matcher fulltreeMatcher = fulltreePattern.matcher(line);
                if (prevsubtreeMatcher.matches()) {
                    treeString = prevsubtreeMatcher.group(1).trim();
                    if (treeString.endsWith(";")) {
                        treeString = treeString.substring(0, treeString.length() - 1);
                    }
                    treeSpec = new TreeSpec(treeString.trim(), reader.getLineNumber() + 1);
                    expected.put(treeSpec, FactoryTestChecker.canonizeTypeString(prevsubtreeMatcher.group(2)));
                } else if (prevfulltreeMatcher.matches()) {
                    treeString = reader.readLine().trim();
                    if (treeString.endsWith(";")) {
                        treeString = treeString.substring(0, treeString.length() - 1);
                    }
                    treeSpec = new TreeSpec(treeString.trim(), reader.getLineNumber());
                    expected.put(treeSpec, FactoryTestChecker.canonizeTypeString(prevfulltreeMatcher.group(1)));
                } else if (subtreeMatcher.matches()) {
                    treeString = subtreeMatcher.group(2).trim();
                    if (treeString.endsWith(";")) {
                        treeString = treeString.substring(0, treeString.length() - 1);
                    }
                    treeSpec = new TreeSpec(treeString.trim(), reader.getLineNumber());
                    expected.put(treeSpec, FactoryTestChecker.canonizeTypeString(subtreeMatcher.group(3)));
                } else if (fulltreeMatcher.matches()) {
                    treeString = fulltreeMatcher.group(1).trim();
                    if (treeString.endsWith(";")) {
                        treeString = treeString.substring(0, treeString.length() - 1);
                    }
                    treeSpec = new TreeSpec(treeString.trim(), reader.getLineNumber());
                    expected.put(treeSpec, FactoryTestChecker.canonizeTypeString(fulltreeMatcher.group(2)));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return expected;
    }

    private static String canonizeTreeString(String str) {
        String canon = str.trim();
        Pattern pattern = Pattern.compile("(@\\S+)\\(\\)");
        Matcher matcher = pattern.matcher(canon);
        while (matcher.find()) {
            canon = matcher.replaceFirst(matcher.group(1));
            matcher.reset(canon);
        }
        return canon.trim();
    }

    private static String canonizeTypeString(String str) {
        String canon = str.trim();
        canon = canon.replaceAll("\\s+", " ");
        canon = canon.replaceAll("\\[\\s+", "[");
        canon = canon.replaceAll("\\s+\\]", "]");
        canon = canon.replaceAll("<\\s+", "<");
        canon = canon.replaceAll("\\s+>", ">");
        canon = canon.replaceAll("[^\\<]*\\.(?=\\w)", "");
        return canon;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToStringVisitor
    extends SourceVisitor<Void, Void> {
        Map<TreeSpec, String> expected;

        public ToStringVisitor(SourceChecker checker, CompilationUnitTree root) {
            super(checker, root);
            this.expected = FactoryTestChecker.this.buildExpected(root);
        }

        @Override
        public Void scan(Tree tree, Void p) {
            String expectedType;
            String actualType;
            ExpressionTree expTree;
            TreeSpec treeSpec;
            if (tree instanceof ExpressionTree && this.expected.containsKey(treeSpec = new TreeSpec((expTree = (ExpressionTree)tree).toString().trim(), this.root.getLineMap().getLineNumber(((JCTree)((Object)expTree)).pos))) && !(actualType = FactoryTestChecker.canonizeTypeString(this.atypeFactory.getAnnotatedType(expTree).toString())).equals(expectedType = this.expected.get(treeSpec))) {
                FactoryTestChecker.this.report(Result.failure("type.unexpected", tree.toString(), actualType, expectedType), tree);
            }
            return (Void)super.scan(tree, p);
        }
    }

    private static class TreeSpec {
        public final String treeString;
        public final long lineNumber;

        public TreeSpec(String treeString, long lineNumber) {
            this.treeString = FactoryTestChecker.canonizeTreeString(treeString);
            this.lineNumber = lineNumber;
        }

        public int hashCode() {
            return (int)((long)(31 + 3 * this.treeString.hashCode()) + 7L * this.lineNumber);
        }

        public boolean equals(Object o) {
            if (o instanceof TreeSpec) {
                TreeSpec other = (TreeSpec)o;
                return this.treeString.equals(other.treeString) && this.lineNumber == other.lineNumber;
            }
            return false;
        }

        public String toString() {
            return this.lineNumber + ":" + this.treeString;
        }
    }
}

