/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.test;

import checkers.source.SourceChecker;
import checkers.source.SourceVisitor;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.TreeUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeOutputtingChecker
extends SourceChecker {
    @Override
    protected SourceVisitor<?, ?> createSourceVisitor(CompilationUnitTree root) {
        return new Visitor(this, root);
    }

    public static void main(String[] args) {
        JavacProcessingEnvironment env = new JavacProcessingEnvironment(new Context(), Collections.emptyList());
        Elements elements = env.getElementUtils();
        AnnotatedTypeFactory atypeFactory = new AnnotatedTypeFactory(env, null, null, null);
        for (String className : args) {
            TypeElement typeElt = elements.getTypeElement(className);
            TypeOutputtingChecker.printClassType(typeElt, atypeFactory);
        }
    }

    protected static void printClassType(TypeElement typeElt, AnnotatedTypeFactory atypeFactory) {
        assert (typeElt != null);
        String simpleName = typeElt.getSimpleName().toString();
        AnnotatedTypeMirror.AnnotatedDeclaredType type = atypeFactory.fromElement(typeElt);
        System.out.println(simpleName + "\t" + type + "\t" + type.directSuperTypes());
        for (Element element : typeElt.getEnclosedElements()) {
            if (element instanceof TypeElement) {
                TypeOutputtingChecker.printClassType((TypeElement)element, atypeFactory);
            }
            if (!element.getKind().isField() && !(element instanceof ExecutableElement)) continue;
            AnnotatedTypeMirror memberType = atypeFactory.fromElement(element);
            System.out.println(simpleName + "." + element + "\t\t" + memberType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Visitor
    extends SourceVisitor<Void, Void> {
        String currentClass;

        public Visitor(SourceChecker checker, CompilationUnitTree root) {
            super(checker, root);
        }

        @Override
        public Void visitClass(ClassTree node, Void p) {
            TypeElement element = TreeUtils.elementFromDeclaration(node);
            this.currentClass = element.getSimpleName().toString();
            AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.getAnnotatedType(node);
            System.out.println(node.getSimpleName() + "\t" + type + "\t" + type.directSuperTypes());
            return (Void)super.visitClass(node, p);
        }

        @Override
        public Void visitMethod(MethodTree node, Void p) {
            ExecutableElement elem = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedExecutableType type = this.atypeFactory.getAnnotatedType(node);
            System.out.println(this.currentClass + "." + elem + "\t\t" + type);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            VariableElement elem = TreeUtils.elementFromDeclaration(node);
            if (elem.getKind().isField()) {
                AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node);
                System.out.println(this.currentClass + "." + elem + "\t\t" + type);
            }
            return null;
        }
    }
}

