/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public abstract class AbstractTypeProcessor
extends AbstractProcessor {
    private final Set<Name> elements = new HashSet<Name>();
    private boolean hasInvokedTypeProcessingOver = false;
    private JavacProcessingEnvironment env;
    private final AttributionTaskListener listener = new AttributionTaskListener();

    protected AbstractTypeProcessor() {
    }

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.env = (JavacProcessingEnvironment)env;
        this.prepareContext(this.env.getContext());
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement elem : ElementFilter.typesIn(roundEnv.getRootElements())) {
            this.elements.add(elem.getQualifiedName());
        }
        return false;
    }

    public abstract void typeProcess(TypeElement var1, TreePath var2);

    public void typeProcessingOver() {
    }

    private void prepareContext(Context context) {
        TaskListener otherListener = context.get(TaskListener.class);
        if (otherListener == null) {
            context.put(TaskListener.class, this.listener);
        } else {
            context.put(TaskListener.class, (TaskListener)null);
            TaskListeners listeners = new TaskListeners();
            listeners.add(otherListener);
            listeners.add(this.listener);
            context.put(TaskListener.class, listeners);
        }
    }

    private static class TaskListeners
    implements TaskListener {
        private final List<TaskListener> listeners = new ArrayList<TaskListener>();

        private TaskListeners() {
        }

        public void add(TaskListener listener) {
            this.listeners.add(listener);
        }

        public void remove(TaskListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void finished(TaskEvent e) {
            for (TaskListener listener : this.listeners) {
                listener.finished(e);
            }
        }

        @Override
        public void started(TaskEvent e) {
            for (TaskListener listener : this.listeners) {
                listener.started(e);
            }
        }
    }

    private final class AttributionTaskListener
    implements TaskListener {
        private AttributionTaskListener() {
        }

        @Override
        public void finished(TaskEvent e) {
            Log log = Log.instance(AbstractTypeProcessor.this.env.getContext());
            if (!AbstractTypeProcessor.this.hasInvokedTypeProcessingOver && AbstractTypeProcessor.this.elements.isEmpty() && log.nerrors == 0) {
                AbstractTypeProcessor.this.typeProcessingOver();
                AbstractTypeProcessor.this.hasInvokedTypeProcessingOver = true;
            }
            if (e.getKind() != TaskEvent.Kind.ANALYZE) {
                return;
            }
            if (e.getTypeElement() == null) {
                throw new AssertionError((Object)"event task without a type element");
            }
            if (e.getCompilationUnit() == null) {
                throw new AssertionError((Object)"event task without compilation unit");
            }
            if (!AbstractTypeProcessor.this.elements.remove(e.getTypeElement().getQualifiedName())) {
                return;
            }
            if (log.nerrors != 0) {
                return;
            }
            TypeElement elem = e.getTypeElement();
            TreePath p = Trees.instance(AbstractTypeProcessor.this.env).getPath(elem);
            AbstractTypeProcessor.this.typeProcess(elem, p);
            if (!AbstractTypeProcessor.this.hasInvokedTypeProcessingOver && AbstractTypeProcessor.this.elements.isEmpty() && log.nerrors == 0) {
                AbstractTypeProcessor.this.typeProcessingOver();
                AbstractTypeProcessor.this.hasInvokedTypeProcessingOver = true;
            }
        }

        @Override
        public void started(TaskEvent e) {
        }
    }
}

