/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.DocCommentScanner;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends JavacTask {
    private JavacTool tool;
    private Main compilerMain;
    private JavaCompiler compiler;
    private Locale locale;
    private String[] args;
    private Context context;
    private List<JavaFileObject> fileObjects;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private TaskListener taskListener;
    private AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private Integer result = null;
    private boolean parsed = false;

    JavacTaskImpl(JavacTool tool, Main compilerMain, String[] args, Context context, List<JavaFileObject> fileObjects) {
        this.tool = tool;
        this.compilerMain = compilerMain;
        this.args = args;
        this.context = context;
        this.fileObjects = fileObjects;
        this.setLocale(Locale.getDefault());
        compilerMain.getClass();
        args.getClass();
        context.getClass();
        fileObjects.getClass();
        DocCommentScanner.Factory.preRegister(context);
    }

    JavacTaskImpl(JavacTool tool, Main compilerMain, Iterable<String> flags, Context context, Iterable<String> classes, Iterable<? extends JavaFileObject> fileObjects) {
        this(tool, compilerMain, JavacTaskImpl.toArray(flags, classes), context, JavacTaskImpl.toList(fileObjects));
    }

    private static String[] toArray(Iterable<String> flags, Iterable<String> classes) {
        ListBuffer<String> result = new ListBuffer<String>();
        if (flags != null) {
            for (String flag : flags) {
                result.append(flag);
            }
        }
        if (classes != null) {
            for (String cls : classes) {
                result.append(cls);
            }
        }
        return result.toArray(new String[result.length()]);
    }

    private static List<JavaFileObject> toList(Iterable<? extends JavaFileObject> fileObjects) {
        if (fileObjects == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> result = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : fileObjects) {
            result.append(javaFileObject);
        }
        return result.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        if (!this.used.getAndSet(true)) {
            this.beginContext();
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            try {
                this.compilerMain.setFatalErrors(true);
                this.result = this.compilerMain.compile(this.args, this.context, this.fileObjects, this.processors);
            }
            finally {
                this.endContext();
            }
            this.compilerMain = null;
            this.args = null;
            this.context = null;
            this.fileObjects = null;
            this.notYetEntered = null;
            return this.result == 0;
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        processors.getClass();
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = processors;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    private void prepareCompiler() throws IOException {
        if (!this.used.getAndSet(true)) {
            this.beginContext();
            this.compilerMain.setOptions(Options.instance(this.context));
            this.compilerMain.filenames = new ListBuffer();
            List<File> filenames = this.compilerMain.processArgs(CommandLine.parse(this.args));
            if (!filenames.isEmpty()) {
                throw new IllegalArgumentException("Malformed arguments " + filenames.toString(" "));
            }
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.compiler.genEndPos = true;
            this.compiler.initProcessAnnotations(this.processors);
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            for (JavaFileObject file : this.fileObjects) {
                this.notYetEntered.put(file, null);
            }
            this.genList = new ListBuffer();
            this.args = null;
        }
    }

    private void beginContext() {
        this.context.put(JavacTaskImpl.class, this);
        if (this.context.get(TaskListener.class) != null) {
            this.context.put(TaskListener.class, (TaskListener)null);
        }
        if (this.taskListener != null) {
            this.context.put(TaskListener.class, this.wrap(this.taskListener));
        }
        this.tool.beginContext(this.context);
        JavacMessages.instance(this.context).setCurrentLocale(this.locale);
    }

    private TaskListener wrap(final TaskListener tl) {
        tl.getClass();
        return new TaskListener(){

            @Override
            public void started(TaskEvent e) {
                try {
                    tl.started(e);
                }
                catch (Throwable t) {
                    throw new ClientCodeException(t);
                }
            }

            @Override
            public void finished(TaskEvent e) {
                try {
                    tl.finished(e);
                }
                catch (Throwable t) {
                    throw new ClientCodeException(t);
                }
            }
        };
    }

    private void endContext() {
        this.tool.endContext();
    }

    public JavaFileObject asJavaFileObject(File file) {
        JavacFileManager fm = (JavacFileManager)this.context.get(JavaFileManager.class);
        return fm.getRegularFile(file);
    }

    @Override
    public void setTaskListener(TaskListener taskListener) {
        this.taskListener = taskListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends CompilationUnitTree> parse() throws IOException {
        try {
            this.prepareCompiler();
            List<JCTree.JCCompilationUnit> units = this.compiler.parseFiles(this.fileObjects);
            for (JCTree.JCCompilationUnit unit : units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JCTree.JCCompilationUnit> list = units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends TypeElement> enter() throws IOException {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends TypeElement> enter(Iterable<? extends CompilationUnitTree> trees) throws IOException {
        this.prepareCompiler();
        ListBuffer<JCTree.JCCompilationUnit> roots = null;
        if (trees == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parse();
                }
                for (JavaFileObject javaFileObject : this.fileObjects) {
                    JCTree.JCCompilationUnit unit = this.notYetEntered.remove(javaFileObject);
                    if (unit == null) continue;
                    if (roots == null) {
                        roots = new ListBuffer();
                    }
                    roots.append(unit);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : trees) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    if (roots == null) {
                        roots = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    roots.append((JCTree.JCCompilationUnit)compilationUnitTree);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (roots == null) {
            return List.nil();
        }
        try {
            List<JCTree.JCCompilationUnit> units = this.compiler.enterTrees(roots.toList());
            if (this.notYetEntered.isEmpty()) {
                this.compiler = this.compiler.processAnnotations(units);
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCCompilationUnit unit : units) {
                for (JCTree node : unit.defs) {
                    if (node.getTag() != 3) continue;
                    listBuffer.append(((JCTree.JCClassDecl)node).sym);
                }
            }
            List list = listBuffer.toList();
            return list;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    @Override
    public Iterable<? extends Element> analyze() throws IOException {
        return this.analyze(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends TypeElement> classes) throws IOException {
        this.enter(null);
        final ListBuffer<Element> results = new ListBuffer<Element>();
        try {
            if (classes == null) {
                this.handleFlowResults(this.compiler.flow(this.compiler.attribute(this.compiler.todo)), results);
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env)), results);
                    }
                };
                f.run(this.compiler.todo, classes);
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> elems) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case 3: {
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                    if (cdef.sym == null) break;
                    elems.append(cdef.sym);
                    break;
                }
                case 1: {
                    JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)env.tree;
                    if (unit.packge == null) break;
                    elems.append(unit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() throws IOException {
        return this.generate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends TypeElement> classes) throws IOException {
        final ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (classes == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), results);
                this.genList.clear();
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), results);
                    }
                };
                f.run(this.genList, classes);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.compiler.log.flush();
                this.endContext();
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    @Override
    public TypeMirror getTypeMirror(Iterable<? extends Tree> path) {
        Tree last = null;
        Iterator<? extends Tree> i$ = path.iterator();
        while (i$.hasNext()) {
            Tree node;
            last = node = i$.next();
        }
        return ((JCTree)last).type;
    }

    @Override
    public JavacElements getElements() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacElements.instance(this.context);
    }

    @Override
    public JavacTypes getTypes() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacTypes.instance(this.context);
    }

    public Iterable<? extends Tree> pathFor(CompilationUnitTree unit, Tree node) {
        return TreeInfo.pathFor((JCTree)node, (JCTree.JCCompilationUnit)unit).reverse();
    }

    public Context getContext() {
        return this.context;
    }

    public void updateContext(Context newContext) {
        this.context = newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String expr, TypeElement scope) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            CharBuffer buf = CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            Parser parser = parserFactory.newParser(buf, false, false, false);
            JCTree.JCExpression tree = parser.parseType();
            Type type = attr.attribType((JCTree)tree, (Symbol.TypeSymbol)((Object)scope));
            return type;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> list, Iterable<? extends TypeElement> classes) {
            HashSet<TypeElement> set = new HashSet<TypeElement>();
            for (TypeElement typeElement : classes) {
                set.add(typeElement);
            }
            ListBuffer<Object> defer = ListBuffer.lb();
            while (list.peek() != null) {
                Env<AttrContext> env = list.remove();
                Symbol.ClassSymbol csym = env.enclClass.sym;
                if (csym != null && set.contains(csym.outermostClass())) {
                    this.process(env);
                    continue;
                }
                defer = defer.append(env);
            }
            list.addAll(defer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

