/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.ElementKind;

public class TypeAnnotations {
    private static final Context.Key<TypeAnnotations> key = new Context.Key();
    private final Symtab syms;
    private final Names names;

    public static TypeAnnotations instance(Context context) {
        TypeAnnotations instance = context.get(key);
        if (instance == null) {
            instance = new TypeAnnotations(context);
        }
        return instance;
    }

    protected TypeAnnotations(Context context) {
        context.put(key, this);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
    }

    public Annotate.Annotator annotator(final JCTree.JCClassDecl tree) {
        return new Annotate.Annotator(){

            @Override
            public void enterAnnotation() {
                TypeAnnotations.this.taFillAndLift(tree, false);
            }
        };
    }

    public void taFillAndLift(List<JCTree.JCCompilationUnit> trees, boolean visitBodies) {
        for (JCTree.JCCompilationUnit tree : trees) {
            for (JCTree def : tree.defs) {
                if (def.getTag() != 3) continue;
                this.taFillAndLift((JCTree.JCClassDecl)def, visitBodies);
            }
        }
    }

    public void taFillAndLift(JCTree.JCClassDecl tree, boolean visitBodies) {
        new AnnotationsKindSeparator(visitBodies).scan(tree);
        new TypeAnnotationPositions(visitBodies).scan(tree);
        new TypeAnnotationLift(visitBodies).scan(tree);
    }

    private void separateAnnotationsKinds(Symbol sym, Type type, TypeAnnotationPosition pos) {
        List<Attribute.Compound> annotations = sym.attributes_field;
        ListBuffer<Attribute.Compound> declAnnos = new ListBuffer<Attribute.Compound>();
        ListBuffer<Attribute.TypeCompound> typeAnnos = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.Compound a : annotations) {
            switch (this.annotationType(a, sym)) {
                case DECLARATION: {
                    declAnnos.append(a);
                    break;
                }
                case BOTH: {
                    declAnnos.append(a);
                    Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                    typeAnnos.append(ta);
                    break;
                }
                case TYPE: {
                    Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                    typeAnnos.append(ta);
                    break;
                }
            }
        }
        sym.attributes_field = declAnnos.toList();
        List<Attribute.TypeCompound> typeAnnotations = typeAnnos.toList();
        Type atype = this.typeWithAnnotations(type, typeAnnotations);
        if (sym.getKind() == ElementKind.METHOD) {
            sym.type.asMethodType().restype = atype;
        } else {
            sym.type = atype;
        }
        sym.typeAnnotations = sym.typeAnnotations.appendList(typeAnnotations);
        if (sym.getKind() == ElementKind.PARAMETER || sym.getKind() == ElementKind.LOCAL_VARIABLE) {
            sym.owner.typeAnnotations = sym.owner.typeAnnotations.appendList(typeAnnotations);
        }
    }

    private Type typeWithAnnotations(Type type, List<Attribute.TypeCompound> annotations) {
        if (type.tag != 11) {
            Type atype = (Type)type.clone();
            atype.typeAnnotations = List.convert(Attribute.Compound.class, annotations);
            return atype;
        }
        Type.ArrayType arType = (Type.ArrayType)type;
        int depth = 0;
        while (arType.elemtype.tag == 11) {
            arType = (Type.ArrayType)arType.elemtype;
            ++depth;
        }
        arType.elemtype = this.typeWithAnnotations(arType.elemtype, annotations);
        for (Attribute.TypeCompound a : annotations) {
            TypeAnnotationPosition p = a.position;
            p.location = p.location.append(depth);
            p.type = p.type.getGenericComplement();
        }
        return type;
    }

    private Attribute.TypeCompound toTypeCompound(Attribute.Compound a, TypeAnnotationPosition p) {
        return new Attribute.TypeCompound(a, p.clone());
    }

    private boolean areAllDecl(Symbol s) {
        for (Attribute.Compound a : s.attributes_field) {
            if (this.annotationType(a, s) == AnnotationType.DECLARATION) continue;
            return false;
        }
        return true;
    }

    AnnotationType annotationType(Attribute.Compound a, Symbol s) {
        Attribute.Compound atTarget = a.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return this.inferTargetMetaInfo(a, s);
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            System.out.printf("Bad @Target argument %s (%s)%n", atValue, atValue.getClass());
            return AnnotationType.DECLARATION;
        }
        Attribute.Array arr = (Attribute.Array)atValue;
        boolean isDecl = false;
        boolean isType = false;
        for (Attribute app : arr.values) {
            if (!(app instanceof Attribute.Enum)) {
                System.out.printf("annotationType(): unrecognized app=%s (%s)%n", app, app.getClass());
                isDecl = true;
                continue;
            }
            Attribute.Enum e = (Attribute.Enum)app;
            if (e.value.name == this.names.TYPE) {
                if (s.kind != 2) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.FIELD) {
                if (s.kind != 4 || s.owner.kind == 16) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.METHOD) {
                if (s.kind != 16 || s.isConstructor()) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.PARAMETER) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) == 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.CONSTRUCTOR) {
                if (s.kind != 16 || !s.isConstructor()) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.LOCAL_VARIABLE) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) != 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.ANNOTATION_TYPE) {
                if (s.kind != 2 || (s.flags() & 0x2000L) == 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.PACKAGE) {
                if (s.kind != 1) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.TYPE_USE) {
                if (s.kind != 2 && s.kind != 4 && (s.kind != 16 || s.isConstructor() || s.type.getReturnType().tag == 9)) continue;
                isType = true;
                continue;
            }
            if (e.value.name == this.names.TYPE_PARAMETER) {
                if (s.kind != 2 && s.kind != 4) continue;
                isType = true;
                continue;
            }
            System.out.printf("annotationType(): unrecognized e.value.name=%s (%s)%n", e.value.name, e.value.name.getClass());
            isDecl = true;
        }
        if (isDecl && isType) {
            return AnnotationType.BOTH;
        }
        return isType ? AnnotationType.TYPE : AnnotationType.DECLARATION;
    }

    private AnnotationType inferTargetMetaInfo(Attribute.Compound a, Symbol s) {
        if (s.kind == 2 || s.kind == 4 || s.kind == 16 && !s.isConstructor() && s.type.getReturnType().tag != 9) {
            return AnnotationType.BOTH;
        }
        return AnnotationType.DECLARATION;
    }

    private static class TypeAnnotationLift
    extends TreeScanner {
        List<Attribute.TypeCompound> recordedTypeAnnotations = List.nil();
        private final boolean visitBodies;
        boolean isInner = false;
        private boolean isCatchParameter = false;

        private static <T> List<T> appendUnique(List<T> l1, List<T> l2) {
            if (l1.isEmpty() || l2.isEmpty()) {
                return l1.appendList(l2);
            }
            ListBuffer buf = ListBuffer.lb();
            buf.appendList(l1);
            for (T i : l2) {
                if (l1.contains(i)) continue;
                buf.append(i);
            }
            return buf.toList();
        }

        TypeAnnotationLift(boolean visitBodies) {
            this.visitBodies = visitBodies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInner) {
                return;
            }
            this.isInner = true;
            List<Attribute.TypeCompound> prevTAs = this.recordedTypeAnnotations;
            this.recordedTypeAnnotations = List.nil();
            try {
                super.visitClassDef(tree);
            }
            finally {
                tree.sym.typeAnnotations = TypeAnnotationLift.appendUnique(tree.sym.typeAnnotations, this.recordedTypeAnnotations);
                this.recordedTypeAnnotations = prevTAs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            List<Attribute.TypeCompound> prevTAs = this.recordedTypeAnnotations;
            this.recordedTypeAnnotations = List.nil();
            try {
                super.visitMethodDef(tree);
            }
            finally {
                tree.sym.typeAnnotations = TypeAnnotationLift.appendUnique(tree.sym.typeAnnotations, this.recordedTypeAnnotations);
                this.recordedTypeAnnotations = prevTAs;
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (this.visitBodies) {
                super.visitBlock(tree);
            }
        }

        @Override
        public void visitCatch(JCTree.JCCatch tree) {
            this.isCatchParameter = true;
            this.scan(tree.param);
            this.isCatchParameter = false;
            this.scan(tree.body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            ElementKind kind;
            List<Attribute.TypeCompound> prevTAs;
            block6: {
                prevTAs = this.recordedTypeAnnotations;
                this.recordedTypeAnnotations = List.nil();
                kind = tree.sym.getKind();
                if (tree.mods.annotations.nonEmpty() && (kind == ElementKind.LOCAL_VARIABLE || this.isCatchParameter)) {
                    TypeAnnotationPosition position = new TypeAnnotationPosition();
                    position.pos = tree.pos;
                    position.type = TargetType.LOCAL_VARIABLE;
                    for (Attribute.Compound attribute : tree.sym.attributes_field) {
                        Attribute.TypeCompound tc = new Attribute.TypeCompound(attribute.type, attribute.values, position);
                        this.recordedTypeAnnotations = this.recordedTypeAnnotations.append(tc);
                    }
                }
                try {
                    this.scan(tree.mods);
                    this.scan(tree.vartype);
                    if (this.visitBodies) {
                        this.scan(tree.init);
                    }
                    if (!kind.isField() && kind != ElementKind.LOCAL_VARIABLE && !this.isCatchParameter) break block6;
                }
                catch (Throwable throwable) {
                    if (kind.isField() || kind == ElementKind.LOCAL_VARIABLE || this.isCatchParameter) {
                        tree.sym.typeAnnotations = TypeAnnotationLift.appendUnique(tree.sym.typeAnnotations, this.recordedTypeAnnotations);
                    }
                    this.recordedTypeAnnotations = kind.isField() ? prevTAs : prevTAs.appendList(this.recordedTypeAnnotations);
                    throw throwable;
                }
                tree.sym.typeAnnotations = TypeAnnotationLift.appendUnique(tree.sym.typeAnnotations, this.recordedTypeAnnotations);
            }
            this.recordedTypeAnnotations = kind.isField() ? prevTAs : prevTAs.appendList(this.recordedTypeAnnotations);
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.meth);
            this.scan(tree.typeargs);
            this.scan(tree.args);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation tree) {
            if (tree instanceof JCTree.JCTypeAnnotation) {
                this.recordedTypeAnnotations = this.recordedTypeAnnotations.append(((JCTree.JCTypeAnnotation)tree).attribute_field);
            }
            super.visitAnnotation(tree);
        }
    }

    private static class TypeAnnotationPositions
    extends TreeScanner {
        private final boolean visitBodies;
        private ListBuffer<JCTree> frames = ListBuffer.lb();
        private boolean isInner = false;

        TypeAnnotationPositions(boolean visitBodies) {
            this.visitBodies = visitBodies;
        }

        private void push(JCTree t) {
            this.frames = this.frames.prepend(t);
        }

        private JCTree pop() {
            return this.frames.next();
        }

        private JCTree peek2() {
            return (JCTree)this.frames.toList().tail.head;
        }

        @Override
        public void scan(JCTree tree) {
            this.push(tree);
            super.scan(tree);
            this.pop();
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInner) {
                return;
            }
            this.isInner = true;
            super.visitClassDef(tree);
        }

        private TypeAnnotationPosition resolveFrame(JCTree tree, JCTree frame, List<JCTree> path, TypeAnnotationPosition p) {
            switch (frame.getKind()) {
                case TYPE_CAST: {
                    p.type = TargetType.TYPECAST;
                    p.pos = frame.pos;
                    return p;
                }
                case INSTANCE_OF: {
                    p.type = TargetType.INSTANCEOF;
                    p.pos = frame.pos;
                    return p;
                }
                case NEW_CLASS: {
                    JCTree.JCNewClass frameNewClass = (JCTree.JCNewClass)frame;
                    if (frameNewClass.typeargs.contains(tree)) {
                        p.type = TargetType.NEW_TYPE_ARGUMENT;
                        p.type_index = frameNewClass.typeargs.indexOf(tree);
                    } else {
                        p.type = TargetType.NEW;
                    }
                    p.pos = frame.pos;
                    return p;
                }
                case NEW_ARRAY: {
                    p.type = TargetType.NEW;
                    p.pos = frame.pos;
                    return p;
                }
                case CLASS: {
                    p.pos = frame.pos;
                    if (((JCTree.JCClassDecl)frame).extending == tree) {
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = -1;
                    } else if (((JCTree.JCClassDecl)frame).implementing.contains(tree)) {
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = ((JCTree.JCClassDecl)frame).implementing.indexOf(tree);
                    } else if (((JCTree.JCClassDecl)frame).typarams.contains(tree)) {
                        p.type = TargetType.CLASS_TYPE_PARAMETER;
                        p.parameter_index = ((JCTree.JCClassDecl)frame).typarams.indexOf(tree);
                    } else {
                        throw new AssertionError();
                    }
                    return p;
                }
                case METHOD: {
                    JCTree.JCMethodDecl frameMethod = (JCTree.JCMethodDecl)frame;
                    p.pos = frame.pos;
                    if (frameMethod.receiverAnnotations.contains(tree)) {
                        p.type = TargetType.METHOD_RECEIVER;
                    } else if (frameMethod.thrown.contains(tree)) {
                        p.type = TargetType.THROWS;
                        p.type_index = frameMethod.thrown.indexOf(tree);
                    } else if (((JCTree.JCMethodDecl)frame).restype == tree) {
                        p.type = TargetType.METHOD_RETURN;
                    } else if (frameMethod.typarams.contains(tree)) {
                        p.type = TargetType.METHOD_TYPE_PARAMETER;
                        p.parameter_index = frameMethod.typarams.indexOf(tree);
                    } else {
                        throw new AssertionError();
                    }
                    return p;
                }
                case MEMBER_SELECT: {
                    JCTree.JCFieldAccess fieldFrame = (JCTree.JCFieldAccess)frame;
                    if (!"class".contentEquals(fieldFrame.name)) {
                        throw new AssertionError();
                    }
                    p.type = TargetType.CLASS_LITERAL;
                    p.pos = TreeInfo.innermostType((JCTree)fieldFrame.selected).pos;
                    return p;
                }
                case PARAMETERIZED_TYPE: {
                    if (((JCTree.JCTypeApply)frame).clazz != tree) {
                        if (((JCTree.JCTypeApply)frame).arguments.contains(tree)) {
                            p.location = p.location.prepend(((JCTree.JCTypeApply)frame).arguments.indexOf(tree));
                        } else {
                            throw new AssertionError();
                        }
                    }
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                }
                case ARRAY_TYPE: {
                    int index = 0;
                    List<JCTree> newPath = path.tail;
                    while (true) {
                        JCTree npHead;
                        if ((npHead = (JCTree)newPath.tail.head).getTag() == 38) {
                            newPath = newPath.tail;
                            ++index;
                            continue;
                        }
                        if (npHead.getTag() != 46) break;
                        newPath = newPath.tail;
                    }
                    p.location = p.location.prepend(index);
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                }
                case TYPE_PARAMETER: {
                    if (((JCTree)path.tail.tail.head).getTag() == 3) {
                        JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)path.tail.tail.head;
                        p.type = TargetType.CLASS_TYPE_PARAMETER_BOUND;
                        p.parameter_index = clazz.typarams.indexOf(path.tail.head);
                        p.bound_index = ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                    } else if (((JCTree)path.tail.tail.head).getTag() == 4) {
                        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)path.tail.tail.head;
                        p.type = TargetType.METHOD_TYPE_PARAMETER_BOUND;
                        p.parameter_index = method.typarams.indexOf(path.tail.head);
                        p.bound_index = ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                    } else {
                        throw new AssertionError();
                    }
                    p.pos = frame.pos;
                    return p;
                }
                case VARIABLE: {
                    Symbol.VarSymbol v = ((JCTree.JCVariableDecl)frame).sym;
                    p.pos = frame.pos;
                    switch (v.getKind()) {
                        case LOCAL_VARIABLE: {
                            p.type = TargetType.LOCAL_VARIABLE;
                            break;
                        }
                        case FIELD: {
                            p.type = TargetType.FIELD;
                            break;
                        }
                        case PARAMETER: {
                            p.type = TargetType.METHOD_PARAMETER;
                            p.parameter_index = this.methodParamIndex(path, frame);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    return p;
                }
                case ANNOTATED_TYPE: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                }
                case METHOD_INVOCATION: {
                    JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)frame;
                    if (!invocation.typeargs.contains(tree)) {
                        throw new AssertionError((Object)("{" + tree + "} is not an argument in the invocation: " + invocation));
                    }
                    p.type = TargetType.METHOD_TYPE_ARGUMENT;
                    p.pos = invocation.pos;
                    p.type_index = invocation.typeargs.indexOf(tree);
                    return p;
                }
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    p.type = TargetType.WILDCARD_BOUND;
                    List<JCTree> newPath = path.tail;
                    TypeAnnotationPosition wildcard = this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, new TypeAnnotationPosition());
                    if (!wildcard.location.isEmpty()) {
                        wildcard.type = wildcard.type.getGenericComplement();
                    }
                    p.wildcard_position = wildcard;
                    p.pos = frame.pos;
                    return p;
                }
            }
            return p;
        }

        private void setTypeAnnotationPos(List<JCTree.JCTypeAnnotation> annotations, TypeAnnotationPosition position) {
            for (JCTree.JCTypeAnnotation anno : annotations) {
                anno.annotation_position = position;
                anno.attribute_field.position = position;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            int i;
            this.findPosition(tree, tree, tree.annotations);
            int dimAnnosCount = tree.dimAnnotations.size();
            for (i = 0; i < dimAnnosCount; ++i) {
                TypeAnnotationPosition p = new TypeAnnotationPosition();
                p.pos = tree.pos;
                if (i == 0) {
                    p.type = TargetType.NEW;
                } else {
                    p.type = TargetType.NEW_GENERIC_OR_ARRAY;
                    p.location = p.location.append(i - 1);
                }
                this.setTypeAnnotationPos(tree.dimAnnotations.get(i), p);
            }
            i = dimAnnosCount == 0 ? 0 : dimAnnosCount - 1;
            JCTree.JCExpression elemType = tree.elemtype;
            while (elemType != null) {
                if (elemType.getTag() == 46) {
                    JCTree.JCAnnotatedType at = (JCTree.JCAnnotatedType)elemType;
                    TypeAnnotationPosition p = new TypeAnnotationPosition();
                    p.type = TargetType.NEW_GENERIC_OR_ARRAY;
                    p.pos = tree.pos;
                    p.location = p.location.append(i);
                    this.setTypeAnnotationPos(at.annotations, p);
                    elemType = at.underlyingType;
                    continue;
                }
                if (elemType.getTag() != 38) break;
                ++i;
                elemType = ((JCTree.JCArrayTypeTree)elemType).elemtype;
            }
            this.scan(tree.elems);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitAnnotatedType(tree);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            super.visitMethodDef(tree);
            TypeAnnotationPosition p = new TypeAnnotationPosition();
            p.type = TargetType.METHOD_RECEIVER;
            this.setTypeAnnotationPos(tree.receiverAnnotations, p);
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (this.visitBodies) {
                super.visitBlock(tree);
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitTypeParameter(tree);
        }

        void findPosition(JCTree tree, JCTree frame, List<JCTree.JCTypeAnnotation> annotations) {
            if (!annotations.isEmpty()) {
                TypeAnnotationPosition p = this.resolveFrame(tree, frame, this.frames.toList(), new TypeAnnotationPosition());
                if (!p.location.isEmpty()) {
                    p.type = p.type.getGenericComplement();
                }
                this.setTypeAnnotationPos(annotations, p);
            }
        }

        private int methodParamIndex(List<JCTree> path, JCTree param) {
            List<JCTree> curr = path;
            if (curr.head != param) {
                curr = path.tail;
            }
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)curr.tail.head;
            return method.params.indexOf(param);
        }
    }

    private class AnnotationsKindSeparator
    extends TreeScanner {
        private final boolean visitBodies;
        private boolean isInner = false;

        public AnnotationsKindSeparator(boolean visitBodies) {
            this.visitBodies = visitBodies;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInner) {
                return;
            }
            this.isInner = true;
            super.visitClassDef(tree);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (!this.visitBodies) {
                if (!TypeAnnotations.this.areAllDecl(tree.sym)) {
                    TypeAnnotations.this.separateAnnotationsKinds(tree.sym, tree.sym.type.getReturnType(), new TypeAnnotationPosition(TargetType.METHOD_RETURN));
                }
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!TypeAnnotations.this.areAllDecl(param.sym)) {
                        TypeAnnotationPosition pos = new TypeAnnotationPosition(TargetType.METHOD_PARAMETER);
                        pos.parameter_index = i;
                        TypeAnnotations.this.separateAnnotationsKinds(param.sym, param.sym.type, pos);
                    }
                    ++i;
                }
            }
            super.visitMethodDef(tree);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (!this.visitBodies && !TypeAnnotations.this.areAllDecl(tree.sym)) {
                if (tree.sym.getKind() == ElementKind.FIELD) {
                    TypeAnnotations.this.separateAnnotationsKinds(tree.sym, tree.sym.type, new TypeAnnotationPosition(TargetType.FIELD));
                } else if (tree.sym.getKind() == ElementKind.LOCAL_VARIABLE) {
                    TypeAnnotationPosition pos = new TypeAnnotationPosition(TargetType.LOCAL_VARIABLE);
                    pos.pos = tree.pos;
                    TypeAnnotations.this.separateAnnotationsKinds(tree.sym, tree.sym.type, pos);
                }
            }
            super.visitVarDef(tree);
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (this.visitBodies) {
                super.visitBlock(tree);
            }
        }
    }

    static enum AnnotationType {
        DECLARATION,
        TYPE,
        BOTH;

    }
}

