/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.HashMap;
import java.util.Map;

public class EndPosParser
extends JavacParser {
    private Lexer S;
    Map<JCTree, Integer> endPositions;

    public EndPosParser(ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap) {
        super(fac, S, keepDocComments, keepLineMap);
        this.S = S;
        this.endPositions = new HashMap<JCTree, Integer>();
    }

    @Override
    protected void storeEnd(JCTree tree, int endpos) {
        int errorEndPos = this.getErrorEndPos();
        this.endPositions.put(tree, errorEndPos > endpos ? errorEndPos : endpos);
    }

    @Override
    protected <T extends JCTree> T to(T t) {
        this.storeEnd(t, this.S.endPos());
        return t;
    }

    @Override
    protected <T extends JCTree> T toP(T t) {
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    @Override
    public JCTree.JCCompilationUnit parseCompilationUnit() {
        JCTree.JCCompilationUnit t = super.parseCompilationUnit();
        t.endPositions = this.endPositions;
        return t;
    }

    @Override
    JCTree.JCExpression parExpression() {
        int pos = this.S.pos();
        JCTree.JCExpression t = super.parExpression();
        return this.toP(this.F.at(pos).Parens(t));
    }

    @Override
    public int getEndPos(JCTree tree) {
        return TreeInfo.getEndPos(tree, this.endPositions);
    }
}

