/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;

public class Scanner
implements Lexer {
    private static boolean scannerDebug = false;
    private Token token;
    private boolean allowHexFloats;
    private boolean allowBinaryLiterals;
    private boolean allowUnderscoresInLiterals;
    private Source source;
    private int pos;
    private int endPos;
    private int prevEndPos;
    private int errPos = -1;
    private Name name;
    private int radix;
    protected boolean deprecatedFlag = false;
    protected boolean magicAt = false;
    protected boolean magicID = false;
    protected boolean magic = false;
    protected boolean annotationsincomments;
    protected boolean spacesincomments;
    protected boolean debugJSR308;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private int eofPos;
    private char ch;
    private int unicodeConversionBp = -1;
    private final Log log;
    private final Names names;
    private final Keywords keywords;
    private static final boolean hexFloatsWork = Scanner.hexFloatsWork();
    static final boolean surrogatesSupported = Scanner.surrogatesSupported();

    private Scanner(Factory fac) {
        this.log = fac.log;
        this.names = fac.names;
        this.keywords = fac.keywords;
        this.source = fac.source;
        this.allowBinaryLiterals = this.source.allowBinaryLiterals();
        this.allowHexFloats = this.source.allowHexFloats();
        this.allowUnderscoresInLiterals = this.source.allowBinaryLiterals();
        this.annotationsincomments = fac.annotationsincomments;
        this.spacesincomments = fac.spacesincomments;
        this.debugJSR308 = fac.debugJSR308;
    }

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected Scanner(Factory fac, CharBuffer buffer) {
        this(fac, JavacFileManager.toArray(buffer), buffer.limit());
    }

    protected Scanner(Factory fac, char[] input, int inputLength) {
        this(fac);
        this.eofPos = inputLength;
        if (inputLength == input.length) {
            if (input.length > 0 && Character.isWhitespace(input[input.length - 1])) {
                --inputLength;
            } else {
                char[] newInput = new char[inputLength + 1];
                System.arraycopy(input, 0, newInput, 0, input.length);
                input = newInput;
            }
        }
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    private void lexError(int pos, String key, Object ... args) {
        this.log.error(pos, key, args);
        this.token = Token.ERROR;
        this.errPos = pos;
    }

    private void lexError(String key, Object ... args) {
        this.lexError(this.pos, key, args);
    }

    private int digit(int base) {
        char c = this.ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            this.lexError(this.pos + 1, "illegal.nonascii.digit", new Object[0]);
            this.ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    private void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.buflen) {
                    int d;
                    int code = d = this.digit(16);
                    while (this.bp < limit && d >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        d = this.digit(16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)code;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError(this.bp, "illegal.unicode.esc", new Object[0]);
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private void scanChar() {
        this.ch = this.buf[++this.bp];
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar(boolean forBytecodeName) {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.ch;
                        int oct = this.digit(8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            oct = oct * 8 + this.digit(8);
                            this.scanChar();
                            if (leadch <= '3' && '0' <= this.ch && this.ch <= '7') {
                                oct = oct * 8 + this.digit(8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    case '!': 
                    case '%': 
                    case ',': 
                    case '-': 
                    case '=': 
                    case '?': 
                    case '^': 
                    case '_': 
                    case '{': 
                    case '|': 
                    case '}': {
                        if (forBytecodeName) {
                            this.putChar('\\');
                            this.putChar(this.ch);
                            this.scanChar();
                            break;
                        }
                        this.lexError(this.bp, "illegal.esc.char", new Object[0]);
                        break;
                    }
                    default: {
                        this.lexError(this.bp, "illegal.esc.char", new Object[0]);
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanLitChar() {
        this.scanLitChar(false);
    }

    private void scanBytecodeNameChar() {
        switch (this.ch) {
            case '.': 
            case '/': 
            case ';': 
            case '<': 
            case '>': 
            case '[': {
                this.lexError(this.bp, "illegal.bytecode.ident.char", String.valueOf((int)this.ch));
            }
        }
        this.scanLitChar(true);
    }

    private void scanDigits(int digitRadix) {
        int savePos;
        char saveCh;
        do {
            if (this.ch != '_') {
                this.putChar(this.ch);
            } else if (!this.allowUnderscoresInLiterals) {
                this.lexError("unsupported.underscore.lit", this.source.name);
                this.allowUnderscoresInLiterals = true;
            }
            saveCh = this.ch;
            savePos = this.bp;
            this.scanChar();
        } while (this.digit(digitRadix) >= 0 || this.ch == '_');
        if (saveCh == '_') {
            this.lexError(savePos, "illegal.underscore", new Object[0]);
        }
    }

    private void scanHexExponentAndSuffix() {
        if (this.ch == 'p' || this.ch == 'P') {
            this.putChar(this.ch);
            this.scanChar();
            this.skipIllegalUnderscores();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.skipIllegalUnderscores();
            if ('0' <= this.ch && this.ch <= '9') {
                this.scanDigits(10);
                if (!this.allowHexFloats) {
                    this.lexError("unsupported.fp.lit", this.source.name);
                    this.allowHexFloats = true;
                } else if (!hexFloatsWork) {
                    this.lexError("unsupported.cross.fp.lit", new Object[0]);
                }
            } else {
                this.lexError("malformed.fp.lit", new Object[0]);
            }
        } else {
            this.lexError("malformed.fp.lit", new Object[0]);
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Token.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Token.DOUBLELITERAL;
        }
    }

    private void scanFraction() {
        this.skipIllegalUnderscores();
        if ('0' <= this.ch && this.ch <= '9') {
            this.scanDigits(10);
        }
        int sp1 = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            this.skipIllegalUnderscores();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.skipIllegalUnderscores();
            if ('0' <= this.ch && this.ch <= '9') {
                this.scanDigits(10);
                return;
            }
            this.lexError("malformed.fp.lit", new Object[0]);
            this.sp = sp1;
        }
    }

    private void scanFractionAndSuffix() {
        this.radix = 10;
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Token.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Token.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(boolean seendigit) {
        this.radix = 16;
        assert (this.ch == '.');
        this.putChar(this.ch);
        this.scanChar();
        this.skipIllegalUnderscores();
        if (this.digit(16) >= 0) {
            seendigit = true;
            this.scanDigits(16);
        }
        if (!seendigit) {
            this.lexError("invalid.hex.number", new Object[0]);
        } else {
            this.scanHexExponentAndSuffix();
        }
    }

    private void skipIllegalUnderscores() {
        if (this.ch == '_') {
            this.lexError(this.bp, "illegal.underscore", new Object[0]);
            while (this.ch == '_') {
                this.scanChar();
            }
        }
    }

    private void scanNumber(int radix) {
        this.radix = radix;
        int digitRadix = radix == 8 ? 10 : radix;
        boolean seendigit = false;
        if (this.digit(digitRadix) >= 0) {
            seendigit = true;
            this.scanDigits(digitRadix);
        }
        if (radix == 16 && this.ch == '.') {
            this.scanHexFractionAndSuffix(seendigit);
        } else if (seendigit && radix == 16 && (this.ch == 'p' || this.ch == 'P')) {
            this.scanHexExponentAndSuffix();
        } else if (digitRadix == 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (digitRadix == 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = Token.LONGLITERAL;
        } else {
            this.token = Token.INTLITERAL;
        }
    }

    private void scanIdent() {
        block4: while (true) {
            boolean isJavaIdentifierPart;
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
            } else {
                this.sbuf[this.sp++] = this.ch;
            }
            this.scanChar();
            switch (this.ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '\u007f': {
                    continue block4;
                }
                case '\u001a': {
                    if (this.bp < this.buflen) continue block4;
                    this.name = this.names.fromChars(this.sbuf, 0, this.sp);
                    this.token = this.keywords.key(this.name);
                    return;
                }
            }
            if (this.ch < '\u0080') {
                isJavaIdentifierPart = false;
            } else {
                char high = this.scanSurrogates();
                if (high != '\u0000') {
                    if (this.sp == this.sbuf.length) {
                        this.putChar(high);
                    } else {
                        this.sbuf[this.sp++] = high;
                    }
                    isJavaIdentifierPart = Character.isJavaIdentifierPart(Character.toCodePoint(high, this.ch));
                } else {
                    isJavaIdentifierPart = Character.isJavaIdentifierPart(this.ch);
                }
            }
            if (!isJavaIdentifierPart) break;
        }
        this.name = this.names.fromChars(this.sbuf, 0, this.sp);
        this.token = this.keywords.key(this.name);
    }

    private static boolean surrogatesSupported() {
        try {
            Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    private char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char high = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return high;
            }
            this.ch = high;
        }
        return '\u0000';
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name newname = this.names.fromChars(this.sbuf, 0, this.sp);
            if (this.keywords.key(newname) == Token.IDENTIFIER) {
                --this.sp;
                break;
            }
            this.name = newname;
            this.token = this.keywords.key(newname);
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocComment() {
        boolean deprecatedPrefix = false;
        block5: while (this.bp < this.buflen) {
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            while (this.bp < this.buflen && this.ch == '*') {
                this.scanCommentChar();
                if (this.ch != '/') continue;
                return;
            }
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            deprecatedPrefix = false;
            if (this.bp < this.buflen && this.ch == '@' && !this.deprecatedFlag) {
                this.scanCommentChar();
                if (this.bp < this.buflen && this.ch == 'd') {
                    this.scanCommentChar();
                    if (this.bp < this.buflen && this.ch == 'e') {
                        this.scanCommentChar();
                        if (this.bp < this.buflen && this.ch == 'p') {
                            this.scanCommentChar();
                            if (this.bp < this.buflen && this.ch == 'r') {
                                this.scanCommentChar();
                                if (this.bp < this.buflen && this.ch == 'e') {
                                    this.scanCommentChar();
                                    if (this.bp < this.buflen && this.ch == 'c') {
                                        this.scanCommentChar();
                                        if (this.bp < this.buflen && this.ch == 'a') {
                                            this.scanCommentChar();
                                            if (this.bp < this.buflen && this.ch == 't') {
                                                this.scanCommentChar();
                                                if (this.bp < this.buflen && this.ch == 'e') {
                                                    this.scanCommentChar();
                                                    if (this.bp < this.buflen && this.ch == 'd') {
                                                        deprecatedPrefix = true;
                                                        this.scanCommentChar();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (deprecatedPrefix && this.bp < this.buflen) {
                if (Character.isWhitespace(this.ch)) {
                    this.deprecatedFlag = true;
                } else if (this.ch == '*') {
                    this.scanCommentChar();
                    if (this.ch == '/') {
                        this.deprecatedFlag = true;
                        return;
                    }
                }
            }
            block9: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        this.scanCommentChar();
                        if (this.ch != '/') continue block9;
                        return;
                    }
                    case '\r': {
                        this.scanCommentChar();
                        if (this.ch != '\n') continue block5;
                    }
                    case '\n': {
                        this.scanCommentChar();
                        continue block5;
                    }
                }
                this.scanCommentChar();
            }
        }
    }

    @Override
    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextToken() {
        if (this.magicAt) {
            this.magicAt = false;
            this.magicID = true;
        }
        if (this.magicID && this.ch == ' ') {
            while (this.ch == ' ') {
                this.scanChar();
            }
        }
        if (this.magicID && this.ch == '*') {
            this.magicID = false;
            this.magic = true;
            this.scanChar();
            if (this.ch != '/') {
                this.lexError("invalid.anno.comment.char", new Object[0]);
            }
            this.scanChar();
        }
        try {
            this.prevEndPos = this.endPos;
            this.sp = 0;
            block45: while (true) {
                this.pos = this.bp;
                switch (this.ch) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        do {
                            this.scanChar();
                        } while (this.ch == ' ' || this.ch == '\t' || this.ch == '\f');
                        this.endPos = this.bp;
                        this.processWhiteSpace();
                        continue block45;
                    }
                    case '\n': {
                        this.scanChar();
                        this.endPos = this.bp;
                        this.processLineTerminator();
                        continue block45;
                    }
                    case '\r': {
                        this.scanChar();
                        if (this.ch == '\n') {
                            this.scanChar();
                        }
                        this.endPos = this.bp;
                        this.processLineTerminator();
                        continue block45;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        return;
                    }
                    case '0': {
                        this.scanChar();
                        if (this.ch == 'x' || this.ch == 'X') {
                            this.scanChar();
                            this.skipIllegalUnderscores();
                            if (this.ch == '.') {
                                this.scanHexFractionAndSuffix(false);
                            } else if (this.digit(16) < 0) {
                                this.lexError("invalid.hex.number", new Object[0]);
                            } else {
                                this.scanNumber(16);
                            }
                        } else if (this.ch == 'b' || this.ch == 'B') {
                            if (!this.allowBinaryLiterals) {
                                this.lexError("unsupported.binary.lit", this.source.name);
                                this.allowBinaryLiterals = true;
                            }
                            this.scanChar();
                            this.skipIllegalUnderscores();
                            if (this.digit(2) < 0) {
                                this.lexError("invalid.binary.number", new Object[0]);
                            } else {
                                this.scanNumber(2);
                            }
                        } else {
                            this.putChar('0');
                            if (this.ch == '_') {
                                int savePos = this.bp;
                                do {
                                    this.scanChar();
                                } while (this.ch == '_');
                                if (this.digit(10) < 0) {
                                    this.lexError(savePos, "illegal.underscore", new Object[0]);
                                }
                            }
                            this.scanNumber(8);
                        }
                        return;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(10);
                        return;
                    }
                    case '.': {
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '9') {
                            this.putChar('.');
                            this.scanFractionAndSuffix();
                        } else if (this.ch == '.') {
                            this.putChar('.');
                            this.putChar('.');
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanChar();
                                this.putChar('.');
                                this.token = Token.ELLIPSIS;
                            } else {
                                this.lexError("malformed.fp.lit", new Object[0]);
                            }
                        } else {
                            this.token = Token.DOT;
                        }
                        return;
                    }
                    case ',': {
                        this.scanChar();
                        this.token = Token.COMMA;
                        return;
                    }
                    case ';': {
                        this.scanChar();
                        this.token = Token.SEMI;
                        return;
                    }
                    case '(': {
                        this.scanChar();
                        this.token = Token.LPAREN;
                        return;
                    }
                    case ')': {
                        this.scanChar();
                        this.token = Token.RPAREN;
                        return;
                    }
                    case '[': {
                        this.scanChar();
                        this.token = Token.LBRACKET;
                        return;
                    }
                    case ']': {
                        this.scanChar();
                        this.token = Token.RBRACKET;
                        return;
                    }
                    case '{': {
                        this.scanChar();
                        this.token = Token.LBRACE;
                        return;
                    }
                    case '}': {
                        this.scanChar();
                        this.token = Token.RBRACE;
                        return;
                    }
                    case '/': {
                        this.scanChar();
                        if (this.ch == '/') {
                            do {
                                this.scanCommentChar();
                            } while (this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen);
                            if (this.bp >= this.buflen) continue block45;
                            this.endPos = this.bp;
                            this.processComment(CommentStyle.LINE);
                            continue block45;
                        }
                        if (this.ch == '*') {
                            CommentStyle style;
                            this.scanChar();
                            if (this.spacesincomments) {
                                while (this.ch == ' ') {
                                    this.scanChar();
                                }
                            }
                            if (this.ch == '*') {
                                style = CommentStyle.JAVADOC;
                                this.scanDocComment();
                                if (this.magicAt) {
                                    return;
                                }
                            } else {
                                if (this.annotationsincomments && this.bp < this.buflen && this.ch == '@' && (this.spacesincomments || this.isCommentWithoutSpaces())) {
                                    this.scanChar();
                                    while (Character.isWhitespace(this.ch)) {
                                        this.scanChar();
                                    }
                                    if (!Character.isJavaIdentifierStart(this.ch)) continue block45;
                                    this.token = Token.MONKEYS_AT;
                                    this.magicAt = true;
                                    return;
                                }
                                style = CommentStyle.BLOCK;
                                while (this.bp < this.buflen) {
                                    if (this.ch == '*') {
                                        this.scanChar();
                                        if (this.ch != '/') continue;
                                        break;
                                    }
                                    if (this.magic && this.ch == '@') {
                                        this.scanChar();
                                        if (Character.isJavaIdentifierStart(this.ch)) {
                                            this.token = Token.MONKEYS_AT;
                                            this.magicAt = true;
                                            return;
                                        }
                                        this.scanChar();
                                        if (this.ch != '/') continue;
                                        break;
                                    }
                                    this.scanCommentChar();
                                    if (Character.isWhitespace(this.ch) && this.ch != '\n') continue;
                                    this.magic = false;
                                }
                            }
                            if (this.ch == '/') {
                                this.scanChar();
                                this.endPos = this.bp;
                                this.processComment(style);
                                continue block45;
                            }
                            this.lexError("unclosed.comment", new Object[0]);
                            return;
                        }
                        if (this.ch == '=') {
                            this.name = this.names.slashequals;
                            this.token = Token.SLASHEQ;
                            this.scanChar();
                        } else {
                            this.name = this.names.slash;
                            this.token = Token.SLASH;
                        }
                        return;
                    }
                    case '\'': {
                        this.scanChar();
                        if (this.ch == '\'') {
                            this.lexError("empty.char.lit", new Object[0]);
                        } else {
                            if (this.ch == '\r' || this.ch == '\n') {
                                this.lexError(this.pos, "illegal.line.end.in.char.lit", new Object[0]);
                            }
                            this.scanLitChar();
                            if (this.ch == '\'') {
                                this.scanChar();
                                this.token = Token.CHARLITERAL;
                            } else {
                                this.lexError(this.pos, "unclosed.char.lit", new Object[0]);
                            }
                        }
                        return;
                    }
                    case '\"': {
                        this.scanChar();
                        while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                            this.scanLitChar();
                        }
                        if (this.ch == '\"') {
                            this.token = Token.STRINGLITERAL;
                            this.scanChar();
                        } else {
                            this.lexError(this.pos, "unclosed.str.lit", new Object[0]);
                        }
                        return;
                    }
                    case '#': {
                        this.scanChar();
                        if (this.ch == '\"') {
                            this.scanChar();
                            if (this.ch == '\"') {
                                this.lexError(this.pos, "empty.bytecode.ident", new Object[0]);
                            }
                            while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                                this.scanBytecodeNameChar();
                            }
                            if (this.ch == '\"') {
                                this.name = this.names.fromChars(this.sbuf, 0, this.sp);
                                this.token = Token.IDENTIFIER;
                                this.scanChar();
                            } else {
                                this.lexError(this.pos, "unclosed.bytecode.ident", new Object[0]);
                            }
                        } else {
                            this.lexError("illegal.char", String.valueOf(35));
                        }
                        return;
                    }
                }
                break;
            }
            if (this.isSpecial(this.ch)) {
                this.scanOperator();
            } else {
                boolean isJavaIdentifierStart;
                if (this.ch < '\u0080') {
                    isJavaIdentifierStart = false;
                } else {
                    char high = this.scanSurrogates();
                    if (high != '\u0000') {
                        if (this.sp == this.sbuf.length) {
                            this.putChar(high);
                        } else {
                            this.sbuf[this.sp++] = high;
                        }
                        isJavaIdentifierStart = Character.isJavaIdentifierStart(Character.toCodePoint(high, this.ch));
                    } else {
                        isJavaIdentifierStart = Character.isJavaIdentifierStart(this.ch);
                    }
                }
                if (isJavaIdentifierStart) {
                    this.scanIdent();
                } else if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                    this.token = Token.EOF;
                    this.pos = this.bp = this.eofPos;
                } else {
                    this.lexError("illegal.char", String.valueOf((int)this.ch));
                    this.scanChar();
                }
            }
            return;
        }
        finally {
            this.endPos = this.bp;
            if (scannerDebug) {
                System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
            }
        }
    }

    private boolean isCommentWithoutSpaces() {
        assert (this.ch == '@');
        int parens = 0;
        int lbp = this.bp;
        while (lbp < this.buflen) {
            char lch = this.buf[++lbp];
            if (parens == 0 && Character.isWhitespace(lch)) {
                return false;
            }
            if (lch == '(') {
                ++parens;
                continue;
            }
            if (lch == ')') {
                --parens;
                continue;
            }
            if (lch != '*' || lbp + 1 >= this.buflen || this.buf[lbp + 1] != '/') continue;
            return true;
        }
        return false;
    }

    @Override
    public Token token() {
        return this.token;
    }

    @Override
    public void token(Token token) {
        this.token = token;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    public int endPos() {
        return this.endPos;
    }

    @Override
    public int prevEndPos() {
        return this.prevEndPos;
    }

    @Override
    public int errPos() {
        return this.errPos;
    }

    @Override
    public void errPos(int pos) {
        this.errPos = pos;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public int radix() {
        return this.radix;
    }

    @Override
    public boolean deprecatedFlag() {
        return this.deprecatedFlag;
    }

    @Override
    public void resetDeprecatedFlag() {
        this.deprecatedFlag = false;
    }

    @Override
    public String docComment() {
        return null;
    }

    @Override
    public char[] getRawCharacters() {
        char[] chars = new char[this.buflen];
        System.arraycopy(this.buf, 0, chars, 0, this.buflen);
        return chars;
    }

    @Override
    public char[] getRawCharacters(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        char[] chars = new char[length];
        System.arraycopy(this.buf, beginIndex, chars, 0, length);
        return chars;
    }

    protected void processComment(CommentStyle style) {
        if (scannerDebug) {
            System.out.println("processComment(" + this.pos + "," + this.endPos + "," + (Object)((Object)style) + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    protected void processWhiteSpace() {
        if (scannerDebug) {
            System.out.println("processWhitespace(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    protected void processLineTerminator() {
        if (scannerDebug) {
            System.out.println("processTerminator(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    @Override
    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.buf, this.buflen, false);
    }

    public static enum CommentStyle {
        LINE,
        BLOCK,
        JAVADOC;

    }

    public static class Factory {
        public static final Context.Key<Factory> scannerFactoryKey = new Context.Key();
        final Log log;
        final Names names;
        final Source source;
        final Keywords keywords;
        final boolean annotationsincomments;
        final boolean spacesincomments;
        final boolean debugJSR308;

        public static Factory instance(Context context) {
            Factory instance = context.get(scannerFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            context.put(scannerFactoryKey, this);
            this.log = Log.instance(context);
            this.names = Names.instance(context);
            this.source = Source.instance(context);
            this.keywords = Keywords.instance(context);
            this.annotationsincomments = this.source.allowTypeAnnotations();
            Options options = Options.instance(context);
            this.spacesincomments = options.get("TA:spacesincomments") != null;
            this.debugJSR308 = options.get("TA:scanner") != null;
        }

        public Scanner newScanner(CharSequence input) {
            if (input instanceof CharBuffer) {
                return new Scanner(this, (CharBuffer)input);
            }
            char[] array = input.toString().toCharArray();
            return this.newScanner(array, array.length);
        }

        public Scanner newScanner(char[] input, int inputLength) {
            return new Scanner(this, input, inputLength);
        }
    }
}

