/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Options;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.tools.JavaFileObject;

public class BasicDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    protected int currentIndentation = 0;

    public BasicDiagnosticFormatter(Options options, JavacMessages msgs) {
        super(msgs, new BasicConfiguration(options));
    }

    public BasicDiagnosticFormatter(JavacMessages msgs) {
        super(msgs, new BasicConfiguration());
    }

    @Override
    public String formatDiagnostic(JCDiagnostic d, Locale l) {
        if (l == null) {
            l = this.messages.getCurrentLocale();
        }
        String format = this.selectFormat(d);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            boolean meta = false;
            if (c == '%' && i < format.length() - 1) {
                meta = true;
                c = format.charAt(++i);
            }
            buf.append(meta ? this.formatMeta(c, d, l) : String.valueOf(c));
        }
        if (this.depth == 0) {
            return this.addSourceLineIfNeeded(d, buf.toString());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatMessage(JCDiagnostic d, Locale l) {
        int prevIndentation = this.currentIndentation;
        try {
            StringBuilder buf = new StringBuilder();
            Collection<String> args = this.formatArguments(d, l);
            String msg = this.localize(l, d.getCode(), args.toArray());
            String[] lines = msg.split("\n");
            if (((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY)) {
                this.currentIndentation += this.getConfiguration().getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY);
                buf.append(this.indent(lines[0], this.currentIndentation));
            }
            if (lines.length > 1 && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS)) {
                this.currentIndentation += this.getConfiguration().getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS);
                for (int i = 1; i < lines.length; ++i) {
                    buf.append("\n" + this.indent(lines[i], this.currentIndentation));
                }
            }
            if (d.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)) {
                this.currentIndentation += this.getConfiguration().getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS);
                for (String sub : this.formatSubdiagnostics(d, l)) {
                    buf.append("\n" + sub);
                }
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.currentIndentation = prevIndentation;
        }
    }

    protected String addSourceLineIfNeeded(JCDiagnostic d, String msg) {
        boolean singleLine;
        if (!this.displaySource(d)) {
            return msg;
        }
        BasicConfiguration conf = this.getConfiguration();
        int indentSource = conf.getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE);
        String sourceLine = "\n" + this.formatSourceLine(d, indentSource);
        boolean bl = singleLine = msg.indexOf("\n") == -1;
        if (singleLine || this.getConfiguration().getSourcePosition() == BasicConfiguration.SourcePosition.BOTTOM) {
            return msg + sourceLine;
        }
        return msg.replaceFirst("\n", Matcher.quoteReplacement(sourceLine) + "\n");
    }

    protected String formatMeta(char c, JCDiagnostic d, Locale l) {
        switch (c) {
            case 'b': {
                return this.formatSource(d, false, l);
            }
            case 'e': {
                return this.formatPosition(d, DiagnosticFormatter.PositionKind.END, l);
            }
            case 'f': {
                return this.formatSource(d, true, l);
            }
            case 'l': {
                return this.formatPosition(d, DiagnosticFormatter.PositionKind.LINE, l);
            }
            case 'c': {
                return this.formatPosition(d, DiagnosticFormatter.PositionKind.COLUMN, l);
            }
            case 'o': {
                return this.formatPosition(d, DiagnosticFormatter.PositionKind.OFFSET, l);
            }
            case 'p': {
                return this.formatKind(d, l);
            }
            case 's': {
                return this.formatPosition(d, DiagnosticFormatter.PositionKind.START, l);
            }
            case 't': {
                boolean usePrefix;
                switch (d.getType()) {
                    case FRAGMENT: {
                        usePrefix = false;
                        break;
                    }
                    case ERROR: {
                        usePrefix = d.getIntPosition() == -1;
                        break;
                    }
                    default: {
                        usePrefix = true;
                    }
                }
                if (usePrefix) {
                    return this.formatKind(d, l);
                }
                return "";
            }
            case 'm': {
                return this.formatMessage(d, l);
            }
            case 'L': {
                return this.formatLintCategory(d, l);
            }
            case '_': {
                return " ";
            }
            case '%': {
                return "%";
            }
        }
        return String.valueOf(c);
    }

    private String selectFormat(JCDiagnostic d) {
        DiagnosticSource source = d.getDiagnosticSource();
        String format = this.getConfiguration().getFormat(BasicConfiguration.BasicFormatKind.DEFAULT_NO_POS_FORMAT);
        if (source != null && source != DiagnosticSource.NO_SOURCE) {
            if (d.getIntPosition() != -1) {
                format = this.getConfiguration().getFormat(BasicConfiguration.BasicFormatKind.DEFAULT_POS_FORMAT);
            } else if (source.getFile() != null && source.getFile().getKind() == JavaFileObject.Kind.CLASS) {
                format = this.getConfiguration().getFormat(BasicConfiguration.BasicFormatKind.DEFAULT_CLASS_FORMAT);
            }
        }
        return format;
    }

    @Override
    public BasicConfiguration getConfiguration() {
        return (BasicConfiguration)super.getConfiguration();
    }

    public static class BasicConfiguration
    extends AbstractDiagnosticFormatter.SimpleConfiguration {
        protected Map<DiagnosticFormatter.Configuration.DiagnosticPart, Integer> indentationLevels;
        protected Map<BasicFormatKind, String> availableFormats;
        protected SourcePosition sourcePosition;

        public BasicConfiguration(Options options) {
            super(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE));
            this.initFormat();
            this.initIndentation();
            String fmt = options.get("diagsFormat");
            if (fmt != null) {
                String[] formats = fmt.split("\\|");
                switch (formats.length) {
                    case 3: {
                        this.setFormat(BasicFormatKind.DEFAULT_CLASS_FORMAT, formats[2]);
                    }
                    case 2: {
                        this.setFormat(BasicFormatKind.DEFAULT_NO_POS_FORMAT, formats[1]);
                    }
                }
                this.setFormat(BasicFormatKind.DEFAULT_POS_FORMAT, formats[0]);
            }
            String srcPos = null;
            srcPos = options.get("sourcePosition");
            if (srcPos != null && srcPos.equals("bottom")) {
                this.setSourcePosition(SourcePosition.BOTTOM);
            } else {
                this.setSourcePosition(SourcePosition.AFTER_SUMMARY);
            }
            String indent = options.get("diagsIndentation");
            if (indent != null) {
                String[] levels = indent.split("\\|");
                try {
                    switch (levels.length) {
                        case 5: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.JLS, Integer.parseInt(levels[4]));
                        }
                        case 4: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, Integer.parseInt(levels[3]));
                        }
                        case 3: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, Integer.parseInt(levels[2]));
                        }
                        case 2: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, Integer.parseInt(levels[1]));
                        }
                    }
                    this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, Integer.parseInt(levels[0]));
                }
                catch (NumberFormatException ex) {
                    this.initIndentation();
                }
            }
        }

        public BasicConfiguration() {
            super(EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE));
            this.initFormat();
            this.initIndentation();
        }

        private void initFormat() {
            this.availableFormats = new HashMap<BasicFormatKind, String>();
            this.setFormat(BasicFormatKind.DEFAULT_POS_FORMAT, "%f:%l:%_%t%L%m");
            this.setFormat(BasicFormatKind.DEFAULT_NO_POS_FORMAT, "%p%L%m");
            this.setFormat(BasicFormatKind.DEFAULT_CLASS_FORMAT, "%f:%_%t%L%m");
        }

        private void initIndentation() {
            this.indentationLevels = new HashMap<DiagnosticFormatter.Configuration.DiagnosticPart, Integer>();
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, 0);
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, 2);
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, 4);
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, 0);
        }

        public int getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart diagPart) {
            return this.indentationLevels.get((Object)diagPart);
        }

        public void setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart diagPart, int nSpaces) {
            this.indentationLevels.put(diagPart, nSpaces);
        }

        public void setSourcePosition(SourcePosition sourcePos) {
            this.sourcePosition = sourcePos;
        }

        public SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        public void setFormat(BasicFormatKind kind, String s) {
            this.availableFormats.put(kind, s);
        }

        public String getFormat(BasicFormatKind kind) {
            return this.availableFormats.get((Object)kind);
        }

        public static enum BasicFormatKind {
            DEFAULT_POS_FORMAT,
            DEFAULT_NO_POS_FORMAT,
            DEFAULT_CLASS_FORMAT;

        }

        public static enum SourcePosition {
            BOTTOM,
            AFTER_SUMMARY;

        }
    }
}

