/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import kz.gov.pki.kalkan.exception.ErrorCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KalkanException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorCode errorCode;
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    public static KalkanException wrap(Throwable exception, ErrorCode errorCode) {
        if (exception instanceof KalkanException) {
            KalkanException se = (KalkanException)exception;
            if (errorCode != null && errorCode != se.getErrorCode()) {
                return new KalkanException(exception.getMessage(), exception, errorCode);
            }
            return se;
        }
        return new KalkanException(exception.getMessage(), exception, errorCode);
    }

    public static KalkanException wrap(Throwable exception) {
        return KalkanException.wrap(exception, null);
    }

    public KalkanException(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public KalkanException(String message, ErrorCode errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public KalkanException(Throwable cause, ErrorCode errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    public KalkanException(String message, Throwable cause, ErrorCode errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public KalkanException setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T get(String name) {
        return (T)this.properties.get(name);
    }

    public KalkanException set(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            this.printStackTrace(new PrintWriter(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            s.println("\t-------------------------------");
            if (this.errorCode != null) {
                s.println("\t" + this.errorCode + ":" + this.errorCode.getClass().getName());
            }
            for (String key : this.properties.keySet()) {
                s.println("\t" + key + "=[" + this.properties.get(key) + "]");
            }
            s.println("\t-------------------------------");
            StackTraceElement[] trace = this.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTrace(s);
            }
            s.flush();
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.errorCode + "]";
    }
}

