/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce;

import java.util.Enumeration;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.cryptopro.ECGOST3410NamedCurves;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveParameterSpec;

public class ECGOST3410NamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        ECDomainParameters ecP = ECGOST3410NamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = ECGOST3410NamedCurves.getByOID(new DERObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return ECGOST3410NamedCurves.getNames();
    }
}

