/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERBitString;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.cryptopro.ECGOST3410NamedCurves;
import kz.gov.pki.kalkan.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x9.X962Parameters;
import kz.gov.pki.kalkan.asn1.x9.X9ECParameters;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.jce.ECGOST3410NamedCurveTable;
import kz.gov.pki.kalkan.jce.interfaces.ECPointEncoder;
import kz.gov.pki.kalkan.jce.interfaces.ECPublicKey;
import kz.gov.pki.kalkan.jce.provider.ProviderUtil;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ec.EC5Util;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveParameterSpec;
import kz.gov.pki.kalkan.jce.spec.ECNamedCurveSpec;
import kz.gov.pki.kalkan.math.ec.ECCurve;
import kz.gov.pki.kalkan.math.ec.ECPoint;

public class EcGost3410_2015PublicKey
implements java.security.interfaces.ECPublicKey,
ECPublicKey,
ECPointEncoder {
    private String algorithm = "ECGOST3410-2015";
    private kz.gov.pki.kalkan.math.ec.ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;
    private DERObjectIdentifier algOid = null;

    public EcGost3410_2015PublicKey(String algorithm, EcGost3410_2015PublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.gostParams = key.gostParams;
        this.algOid = key.algOid;
    }

    public EcGost3410_2015PublicKey(String algorithm, ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.ecSpec = spec.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, spec.getW(), false);
    }

    public EcGost3410_2015PublicKey(String algorithm, kz.gov.pki.kalkan.jce.spec.ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.q = spec.getQ();
        if (spec.getParams() != null) {
            ECCurve curve = spec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, spec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec.getParams());
        } else {
            if (this.q.getCurve() == null) {
                kz.gov.pki.kalkan.jce.spec.ECParameterSpec s = ProviderUtil.getEcImplicitlyCa();
                this.q = s.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public EcGost3410_2015PublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (spec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, dp);
        } else {
            this.ecSpec = spec;
        }
    }

    public EcGost3410_2015PublicKey(String algorithm, ECPublicKeyParameters params, kz.gov.pki.kalkan.jce.spec.ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (spec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, dp);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(spec.getCurve(), spec.getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec);
        }
    }

    public EcGost3410_2015PublicKey(String algorithm, ECPublicKeyParameters params) {
        this.algorithm = algorithm;
        this.ecSpec = null;
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters dp) {
        return new ECParameterSpec(ellipticCurve, new ECPoint(dp.getG().getX().toBigInteger(), dp.getG().getY().toBigInteger()), dp.getN(), dp.getH().intValue());
    }

    public EcGost3410_2015PublicKey(java.security.interfaces.ECPublicKey key) {
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, key.getW(), false);
    }

    public EcGost3410_2015PublicKey(SubjectPublicKeyInfo info) {
        this.populateFromPubKeyInfo(info);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        int i;
        DERBitString bits = info.getPublicKeyData();
        ASN1OctetString key = null;
        this.algorithm = "ECGOST3410-2015";
        this.algOid = info.getAlgorithmId().getObjectId();
        ECNamedCurveParameterSpec spec = null;
        EllipticCurve ellipticCurve = null;
        try {
            key = (ASN1OctetString)ASN1Object.fromByteArray(bits.getBytes());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error recovering public key");
        }
        int fieldSize = 32;
        if (this.algOid.equals(KNCAObjectIdentifiers.gost3410_2015_512)) {
            fieldSize = 64;
        }
        byte[] keyEnc = key.getOctets();
        byte[] x = new byte[fieldSize];
        byte[] y = new byte[fieldSize];
        for (i = 0; i != x.length; ++i) {
            x[i] = keyEnc[fieldSize - 1 - i];
        }
        for (i = 0; i != y.length; ++i) {
            y[i] = keyEnc[fieldSize * 2 - 1 - i];
        }
        this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)info.getAlgorithmId().getParameters());
        spec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
        ECCurve curve = spec.getCurve();
        ellipticCurve = EC5Util.convertCurve(curve, spec.getSeed());
        this.q = curve.createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
        this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()), ellipticCurve, new ECPoint(spec.getG().getX().toBigInteger(), spec.getG().getY().toBigInteger()), spec.getN(), spec.getH());
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        DERObjectIdentifier algIdentifier;
        int offset;
        int encKeySize;
        BigInteger bX = this.q.getX().toBigInteger();
        BigInteger bY = this.q.getY().toBigInteger();
        boolean is512 = bX.bitLength() > 256;
        ASN1Encodable params = this.getGostParams();
        if (params == null) {
            if (this.ecSpec instanceof ECNamedCurveSpec) {
                params = is512 ? new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), KNCAObjectIdentifiers.gost3411_2015_512) : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), KNCAObjectIdentifiers.gost3411_2015_256);
            } else {
                ECCurve curve = EC5Util.convertCurve(this.ecSpec.getCurve());
                X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint(curve, this.ecSpec.getGenerator(), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                params = new X962Parameters(ecP);
            }
        }
        if (is512) {
            encKeySize = 128;
            offset = 64;
            algIdentifier = KNCAObjectIdentifiers.gost3410_2015_512;
        } else {
            encKeySize = 64;
            offset = 32;
            algIdentifier = KNCAObjectIdentifiers.gost3410_2015_256;
        }
        byte[] encKey = new byte[encKeySize];
        this.extractBytes(encKey, encKeySize / 2, 0, bX);
        this.extractBytes(encKey, encKeySize / 2, offset, bY);
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(algIdentifier, params), new DEROctetString(encKey));
        return info.getDEREncoded();
    }

    private void extractBytes(byte[] encKey, int size, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < size) {
            System.arraycopy(val, 0, encKey, size / 2, val.length);
            return;
        }
        for (int i = 0; i != size; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public kz.gov.pki.kalkan.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec, this.withCompression);
    }

    public ECPoint getW() {
        return new ECPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger());
    }

    public kz.gov.pki.kalkan.math.ec.ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    public kz.gov.pki.kalkan.math.ec.ECPoint engineGetQ() {
        return this.q;
    }

    kz.gov.pki.kalkan.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec, this.withCompression);
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String nl = System.getProperty("line.separator");
        buf.append("ECGOST3410-2015 Public Key").append(nl);
        buf.append("            X: ").append(this.q.getX().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.q.getY().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EcGost3410_2015PublicKey)) {
            return false;
        }
        EcGost3410_2015PublicKey other = (EcGost3410_2015PublicKey)o;
        return this.engineGetQ().equals(other.engineGetQ()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.engineGetQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(enc)));
        this.algorithm = (String)in.readObject();
        this.withCompression = in.readBoolean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getEncoded());
        out.writeObject(this.algorithm);
        out.writeBoolean(this.withCompression);
    }

    public GOST3410PublicKeyAlgParameters getGostParams() {
        if (this.gostParams == null && this.ecSpec instanceof ECNamedCurveSpec) {
            BigInteger bX = this.q.getX().toBigInteger();
            boolean is512 = bX.bitLength() > 256;
            this.gostParams = is512 ? new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), KNCAObjectIdentifiers.gost3411_2015_512) : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), KNCAObjectIdentifiers.gost3411_2015_256);
        }
        return this.gostParams;
    }
}

