/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1OctetStringParser;
import kz.gov.pki.kalkan.asn1.ASN1OutputStream;
import kz.gov.pki.kalkan.asn1.ASN1SequenceParser;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.ASN1SetParser;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.cms.EncryptedContentInfoParser;
import kz.gov.pki.kalkan.asn1.cms.EnvelopedDataParser;
import kz.gov.pki.kalkan.asn1.cms.KEKRecipientInfo;
import kz.gov.pki.kalkan.asn1.cms.KeyAgreeRecipientInfo;
import kz.gov.pki.kalkan.asn1.cms.KeyTransRecipientInfo;
import kz.gov.pki.kalkan.asn1.cms.PasswordRecipientInfo;
import kz.gov.pki.kalkan.asn1.cms.RecipientInfo;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.jce.provider.cms.CMSContentInfoParser;
import kz.gov.pki.kalkan.jce.provider.cms.CMSEnvelopedHelper;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.KEKRecipientInformation;
import kz.gov.pki.kalkan.jce.provider.cms.KeyAgreeRecipientInformation;
import kz.gov.pki.kalkan.jce.provider.cms.KeyTransRecipientInformation;
import kz.gov.pki.kalkan.jce.provider.cms.PasswordRecipientInformation;
import kz.gov.pki.kalkan.jce.provider.cms.RecipientInformation;
import kz.gov.pki.kalkan.jce.provider.cms.RecipientInformationStore;

public class CMSEnvelopedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore _recipientInfoStore;
    EnvelopedDataParser _envelopedData = new EnvelopedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier _encAlg;
    private AttributeTable _unprotectedAttributes;
    private boolean _attrNotRead = true;

    public CMSEnvelopedDataParser(byte[] envelopedData) throws CMSException, IOException {
        this(new ByteArrayInputStream(envelopedData));
    }

    public CMSEnvelopedDataParser(InputStream envelopedData) throws CMSException, IOException {
        super(envelopedData);
        ASN1SetParser s = this._envelopedData.getRecipientInfos();
        ArrayList<RecipientInfo> baseInfos = new ArrayList<RecipientInfo>();
        ASN1Set set = ASN1Set.getInstance(s.getDERObject());
        Enumeration en = set.getObjects();
        while (en.hasMoreElements()) {
            baseInfos.add(RecipientInfo.getInstance(en.nextElement()));
        }
        EncryptedContentInfoParser encInfo = this._envelopedData.getEncryptedContentInfo();
        this._encAlg = encInfo.getContentEncryptionAlgorithm();
        ArrayList<RecipientInformation> infos = new ArrayList<RecipientInformation>();
        Iterator it = baseInfos.iterator();
        InputStream dataStream = ((ASN1OctetStringParser)encInfo.getEncryptedContent(4)).getOctetStream();
        while (it.hasNext()) {
            RecipientInfo info = (RecipientInfo)it.next();
            if (info.getInfo() instanceof KeyTransRecipientInfo) {
                infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)info.getInfo(), this._encAlg, dataStream));
                continue;
            }
            if (info.getInfo() instanceof KEKRecipientInfo) {
                infos.add(new KEKRecipientInformation((KEKRecipientInfo)info.getInfo(), this._encAlg, dataStream));
                continue;
            }
            if (info.getInfo() instanceof KeyAgreeRecipientInfo) {
                infos.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)info.getInfo(), this._encAlg, dataStream));
                continue;
            }
            if (!(info.getInfo() instanceof PasswordRecipientInfo)) continue;
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)info.getInfo(), this._encAlg, dataStream));
        }
        this._recipientInfoStore = new RecipientInformationStore(infos);
    }

    public String getEncryptionAlgOID() {
        return this._encAlg.getObjectId().toString();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this._encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this._recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() throws IOException {
        if (this._unprotectedAttributes == null && this._attrNotRead) {
            ASN1SetParser set = this._envelopedData.getUnprotectedAttrs();
            this._attrNotRead = false;
            if (set != null) {
                DEREncodable o;
                ASN1EncodableVector v = new ASN1EncodableVector();
                while ((o = set.readObject()) != null) {
                    ASN1SequenceParser seq = (ASN1SequenceParser)o;
                    v.add(seq.getDERObject());
                }
                this._unprotectedAttributes = new AttributeTable(new DERSet(v));
            }
        }
        return this._unprotectedAttributes;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(obj);
            return bOut.toByteArray();
        }
        return null;
    }
}

