/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc;

import java.util.HashMap;
import java.util.Map;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.Smartcard;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.pcsc.tokens.AKey;
import kz.gov.pki.kalkan.pcsc.tokens.EToken5110;
import kz.gov.pki.kalkan.pcsc.tokens.EToken72K;
import kz.gov.pki.kalkan.pcsc.tokens.JaCarta;
import kz.gov.pki.kalkan.pcsc.tokens.KZIDCard;
import kz.gov.pki.kalkan.pcsc.tokens.Kaztoken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TokenDispatcher {
    INSTANCE;

    public static final String JACARTA = "AKJaCartaStore";
    public static final String KAZTOKEN = "AKKaztokenStore";
    public static final String KZIDCARD = "AKKZIDCardStore";
    public static final String KORGANS = "AKKorganSStore";
    public static final String ETOKEN72K = "AKEtoken72KStore";
    public static final String ETOKEN5110 = "AKEtoken5110Store";
    public static final String AKEY = "AKAKEYStore";
    public static final Map<Integer, String> storeTypesMap;
    private Map<String, AKToken> tokenMap = new HashMap<String, AKToken>();

    @Deprecated
    public AKToken instantiateToken(String tType, String tName, String pin) throws KalkanException {
        AKToken token = this.tokenMap.get(tName);
        if (token != null) {
            this.tokenMap.remove(tName);
            token = null;
        }
        if (token == null) {
            if (tType.equalsIgnoreCase(KAZTOKEN)) {
                token = new Kaztoken(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase(KZIDCARD)) {
                token = new KZIDCard(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase(ETOKEN72K)) {
                token = new EToken72K(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase(ETOKEN5110)) {
                token = new EToken5110(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase(JACARTA)) {
                token = new JaCarta(tName, pin);
                this.tokenMap.put(tName, token);
            } else if (tType.equalsIgnoreCase(AKEY)) {
                token = new AKey(tName, pin);
                this.tokenMap.put(tName, token);
            }
        }
        return token;
    }

    public AKToken instantiateToken(Smartcard smartcard, char[] password) throws KalkanException {
        return this.instantiateToken(smartcard.getType(), smartcard.getTerminalName(), new String(password));
    }

    public AKToken getToken(String tName) throws KalkanException {
        AKToken token = this.tokenMap.get(tName);
        if (token == null) {
            throw new KalkanException("Token (" + tName + ") is not available", (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return token;
    }

    public void removeToken(String tName) {
        AKToken token = this.tokenMap.get(tName);
        this.removeToken(token);
    }

    public void removeToken(AKToken token) {
        if (token != null) {
            token.disconnect();
            this.tokenMap.remove(token.getTName());
        }
    }

    static {
        storeTypesMap = new HashMap<Integer, String>();
    }
}

