/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.keystores;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.AKPublicKeyUtil;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTokenKeyStore
extends KeyStoreSpi {
    protected AKToken token;

    AbstractTokenKeyStore() {
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey ret = null;
        try {
            String pin = password != null ? String.valueOf(password) : null;
            this.token.setPin(pin);
            ret = this.token.getKey(alias);
        }
        catch (KalkanException e) {
            throw new UnrecoverableKeyException(e.toString());
        }
        return ret;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate ret = null;
        try {
            byte[] cert = this.token.getCertificate(alias);
            if (cert != null) {
                ret = CertificateFactory.getInstance("X509", "KALKAN").generateCertificate(new ByteArrayInputStream(cert));
            }
        }
        catch (CertificateException e) {
            System.err.println(e);
        }
        catch (KalkanException e) {
            System.err.println(e);
        }
        catch (NoSuchProviderException e) {
            System.err.println(e);
        }
        return ret;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            String alg;
            String algorithm = cert.getPublicKey().getAlgorithm();
            if ("ECGOST3410-2015".equals(algorithm)) {
                alg = "GOST512";
            } else if ("RSA".equals(algorithm)) {
                alg = "RSA";
            } else if ("ECGOST34310".equals(algorithm)) {
                alg = "GOST";
            } else {
                throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
            }
            boolean isFound = false;
            String talias = null;
            Map<String, Byte> aliases = this.token.getAliases();
            for (Map.Entry<String, Byte> entry : aliases.entrySet()) {
                PublicKey publicKey;
                byte[] pubKey = null;
                try {
                    pubKey = this.token.getPublicKey(alg, entry.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pubKey == null || (publicKey = AKPublicKeyUtil.generatePublic(alg, pubKey)) == null || !publicKey.equals(cert.getPublicKey())) continue;
                talias = entry.getKey();
                isFound = true;
                break;
            }
            if (!isFound) {
                throw new KalkanException(PCSCCode.INAPPROPRIATE_CERT);
            }
            this.token.setCertificate(talias, cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
        catch (KalkanException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try {
            this.token.deleteEntry(alias);
        }
        catch (KalkanException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        Enumeration<String> ret = null;
        try {
            ret = Collections.enumeration(this.token.getAliases().keySet());
        }
        catch (KalkanException e) {
            System.err.println(e);
        }
        return ret;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        boolean ret = false;
        try {
            return this.token.getAliases().keySet().contains(alias);
        }
        catch (KalkanException e) {
            System.err.println(e);
            return ret;
        }
    }

    @Override
    public int engineSize() {
        int ret = 0;
        try {
            ret = this.token.getAliases().size();
        }
        catch (KalkanException e) {
            System.err.println(e);
        }
        return ret;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password != null) {
            try {
                this.token.changePin((byte)2, new String(password));
            }
            catch (KalkanException e) {
                throw new IOException(e);
            }
        }
        TokenDispatcher.INSTANCE.removeToken(this.token);
    }
}

