/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.adapter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;

public class DateTimeMinutesAdapter
extends XmlAdapter<String, Date> {
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd.MM.yyyy HH:mm");
        }
    };

    public String marshal(Date value) throws Exception {
        return value != null ? THREAD_LOCAL_DATE_FORMATTER.get().format(value) : null;
    }

    public Date unmarshal(String value) throws Exception {
        return !StringUtils.isEmpty((CharSequence)value) ? THREAD_LOCAL_DATE_FORMATTER.get().parse(value) : null;
    }

    public static void main(String[] args) throws Exception {
        DateTimeMinutesAdapter dateTimeMillisAdapter = new DateTimeMinutesAdapter();
        Date current = new Date();
        System.out.println(current.getTime());
        System.out.println(dateTimeMillisAdapter.marshal(current));
        long minute = 60000L;
        Date expireDate = new Date(System.currentTimeMillis() + minute);
        System.out.println(expireDate);
    }
}

