/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.exception.InvoiceVersionNotFoundException;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProduct;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.model.invoice.version.v1.ProductV1;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.model.invoice.version.v2.SellerV2;

public class InvoiceVersionHelper {
    public static String getKogd(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getKogd();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static Long getSellerProjectCode(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getSellerProjectCode();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static Long getCustomerProjectCode(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getCustomerProjectCode();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getSellerAgentTin(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getSellerAgentTin();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getSellerAgentDocNum(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getSellerAgentDocNum();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static Date getSellerAgentDocDate(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getSellerAgentDocDate();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getCustomerAgentTin(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            return ((InvoiceV2)invoice).getCustomerAgentTin();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getDeliveryTermDestination(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getDeliveryTerm().getDestination());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getDeliveryTerm().getDestination());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getFirstSellerTin(AbstractInvoice invoice) {
        List<String> sellerTins = invoice.getSellerTinList();
        if (sellerTins != null && !sellerTins.isEmpty() && sellerTins.get(0) != null) {
            return sellerTins.get(0);
        }
        return null;
    }

    public static String getFirstCustomerTin(AbstractInvoice invoice) {
        List<String> customerTinList = invoice.getCustomerTinList();
        if (customerTinList != null && !customerTinList.isEmpty() && customerTinList.get(0) != null) {
            return customerTinList.get(0);
        }
        return null;
    }

    public static String getFirstSellerBranchTin(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            try {
                return ((SellerV2)invoice.getSellers().get(0)).getBranchTin();
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static void leaveOnlyProductsWithSntNumberByOrderedList(AbstractInvoice invoice, List<String> productNumbersInSntList) {
        if (invoice instanceof InvoiceV1) {
            return;
        }
        if (invoice instanceof InvoiceV2) {
            List<ProductV2> productList = ((InvoiceV2)invoice).getProductList();
            if (CollectionUtils.isNotEmpty(productList) && CollectionUtils.isNotEmpty(productNumbersInSntList)) {
                Map<String, ProductV2> productsMap = productList.stream().filter(p -> p.getProductNumberInSnt() != null).collect(Collectors.toMap(ProductV2::getProductNumberInSnt, p -> p));
                ArrayList<ProductV2> filteredProductList = new ArrayList<ProductV2>();
                for (String num : productNumbersInSntList) {
                    ProductV2 productV2 = productsMap.get(num);
                    if (productV2 == null) continue;
                    filteredProductList.add(productV2);
                }
                ((InvoiceV2)invoice).getProductSet().setProducts(filteredProductList);
            }
        } else {
            throw new InvoiceVersionNotFoundException();
        }
    }

    public static boolean hasOnlyServices(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return false;
        }
        if (invoice instanceof InvoiceV2) {
            List<ProductV2> productList = ((InvoiceV2)invoice).getProductList();
            if (CollectionUtils.isNotEmpty(productList)) {
                return productList.stream().allMatch(p -> "6".equals(p.getTruOriginCode()));
            }
            return false;
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getExportCountry(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getCustomers().get(0).getCountryCode());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getCustomers().get(0).getCountryCode());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getFirstSellerName(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getSellers().get(0).getName());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getSellers().get(0).getName());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getFirstCustomerName(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getCustomers().get(0).getName());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getCustomers().get(0).getName());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getFirstSellerAddress(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getSellers().get(0).getAddress());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getSellers().get(0).getAddress());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getFirstCustomerAddress(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getCustomers().get(0).getAddress());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getCustomers().get(0).getAddress());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getConsignorName(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getConsignor().getName());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getConsignor().getName());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getConsignorTin(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getConsignor().getTin());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getConsignor().getTin());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getConsignorAddress(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getConsignor().getAddress());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getConsignor().getAddress());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getConsigneeName(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getConsignee().getName());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getConsignee().getName());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getConsigneeTin(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getConsignee().getTin());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getConsignee().getTin());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getConsigneeAddress(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV1)invoice, inv -> inv.getConsignee().getAddress());
        }
        if (invoice instanceof InvoiceV2) {
            return LambdaUtils.nullSafeApplyFunction((InvoiceV2)invoice, inv -> inv.getConsignee().getAddress());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static boolean invoiceWithNonSnt(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return "NON SNT".equals(invoice.getDeliveryDocNum());
        }
        if (invoice instanceof InvoiceV2) {
            return "NON SNT".equals(invoice.getDeliveryDocNum()) || "NON SNT".equals(((InvoiceV2)invoice).getDeliveryDocNum2());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static boolean deliveryDocContainsSnt(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum());
        }
        if (invoice instanceof InvoiceV2) {
            return StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum()) || StringUtils.isNotEmpty((CharSequence)((InvoiceV2)invoice).getDeliveryDocNum2()) && RegistrationNumberUtils.isSnt(((InvoiceV2)invoice).getDeliveryDocNum2());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getSntRegNumFromDeliveryDoc(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            if (StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum())) {
                return invoice.getDeliveryDocNum();
            }
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            InvoiceV2 invoiceV2 = (InvoiceV2)invoice;
            if (StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum())) {
                return invoice.getDeliveryDocNum();
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceV2.getDeliveryDocNum2()) && RegistrationNumberUtils.isSnt(invoiceV2.getDeliveryDocNum2())) {
                return invoiceV2.getDeliveryDocNum2();
            }
            return null;
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static boolean deliveryDocContainsEgpAwp(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isEgpAwp(invoice.getDeliveryDocNum());
        }
        if (invoice instanceof InvoiceV2) {
            return StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isEgpAwp(invoice.getDeliveryDocNum()) || StringUtils.isNotEmpty((CharSequence)((InvoiceV2)invoice).getDeliveryDocNum2()) && RegistrationNumberUtils.isEgpAwp(((InvoiceV2)invoice).getDeliveryDocNum2());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static DeliveryDocInfo getEgpAwpInfoFromDeliveryDoc(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            if (StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isEgpAwp(invoice.getDeliveryDocNum())) {
                return new DeliveryDocInfo(invoice.getDeliveryDocNum(), null);
            }
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            InvoiceV2 invoiceV2 = (InvoiceV2)invoice;
            if (StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isEgpAwp(invoice.getDeliveryDocNum())) {
                return new DeliveryDocInfo(invoiceV2.getDeliveryDocNum(), invoiceV2.getDeliveryDocDate());
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceV2.getDeliveryDocNum2()) && RegistrationNumberUtils.isEgpAwp(invoiceV2.getDeliveryDocNum2())) {
                return new DeliveryDocInfo(invoiceV2.getDeliveryDocNum2(), invoiceV2.getDeliveryDocDate2(), 2);
            }
            return null;
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static DeliveryDocInfo getSntInfoFromDeliveryDoc(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            if (StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum())) {
                return new DeliveryDocInfo(invoice.getDeliveryDocNum(), null);
            }
            return null;
        }
        if (invoice instanceof InvoiceV2) {
            InvoiceV2 invoiceV2 = (InvoiceV2)invoice;
            if (StringUtils.isNotEmpty((CharSequence)invoice.getDeliveryDocNum()) && RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum())) {
                return new DeliveryDocInfo(invoiceV2.getDeliveryDocNum(), invoiceV2.getDeliveryDocDate());
            }
            if (StringUtils.isNotEmpty((CharSequence)invoiceV2.getDeliveryDocNum2()) && RegistrationNumberUtils.isSnt(invoiceV2.getDeliveryDocNum2())) {
                return new DeliveryDocInfo(invoiceV2.getDeliveryDocNum2(), invoiceV2.getDeliveryDocDate2(), 2);
            }
            return null;
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getProductDescription(AbstractProduct product) {
        if (product instanceof ProductV1) {
            return ((ProductV1)product).getDescription();
        }
        if (product instanceof ProductV2) {
            return ((ProductV2)product).getDescription();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getProductMeasureUnitCode(AbstractProduct product) {
        if (product instanceof ProductV1) {
            return ((ProductV1)product).getUnitNomenclature();
        }
        if (product instanceof ProductV2) {
            return ((ProductV2)product).getUnitNomenclature();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getProductDeclaration(AbstractProduct product) {
        if (product instanceof ProductV1) {
            return ((ProductV1)product).getApplicationNumberInCustomsUnion();
        }
        if (product instanceof ProductV2) {
            return ((ProductV2)product).getProductDeclaration();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getProductNumberInDeclaration(AbstractProduct product) {
        if (product instanceof ProductV1) {
            return null;
        }
        if (product instanceof ProductV2) {
            return ((ProductV2)product).getProductNumberInDeclaration();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getCurrencyCode(AbstractInvoice invoice) {
        if (invoice instanceof InvoiceV1) {
            return ((InvoiceV1)invoice).getProductSet().getCurrencyCode();
        }
        if (invoice instanceof InvoiceV2) {
            InvoiceV2 invoiceV2 = (InvoiceV2)invoice;
            return ((InvoiceV2)invoice).getProductSet().getCurrencyCode();
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static void setProductQuantity(AbstractProduct product, BigDecimal quantity) {
        if (product instanceof ProductV1) {
            ((ProductV1)product).setQuantity(quantity);
        } else if (product instanceof ProductV2) {
            ((ProductV2)product).setQuantity(quantity);
        } else {
            throw new InvoiceVersionNotFoundException();
        }
    }

    public static class DeliveryDocInfo {
        private static final String numProperty = "deliveryDocNum";
        private static final String dateProperty = "deliveryDocDate";
        private String registrationNumber;
        private Date date;
        private int index = 0;

        public DeliveryDocInfo(String registrationNumber, Date date) {
            this.registrationNumber = registrationNumber;
            this.date = date;
        }

        public DeliveryDocInfo(String registrationNumber, Date date, int index) {
            this.registrationNumber = registrationNumber;
            this.date = date;
            this.index = index;
        }

        public String getRegistrationNumber() {
            return this.registrationNumber;
        }

        public Date getDate() {
            return this.date;
        }

        public String getNumProperty() {
            return numProperty + (this.index > 1 ? Integer.valueOf(this.index) : "");
        }

        public String getDateProperty() {
            return dateProperty + (this.index > 1 ? Integer.valueOf(this.index) : "");
        }
    }
}

