/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.exception.InvoiceVersionNotFoundException;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.esf.model.snt.SntAttachedFile;
import ru.uss.esf.model.snt.SntSectionCode;
import ru.uss.esf.model.snt.SntTransportTypeCode;
import ru.uss.esf.model.snt.abstractsnt.AbstractSnt;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProductSet;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;

public class SntHelper {
    private static final Map<SntSectionCode, String> sectionCodeProductTypeMap = new HashMap<SntSectionCode, String>();
    private static final Map<String, SntSectionCode> productTypeSectionCodeMap = new HashMap<String, SntSectionCode>();
    private static final Map<SntTransportTypeCode, String> transportTypeCodeToTransportTypeMap = new HashMap<SntTransportTypeCode, String>();
    private static final Map<String, SntTransportTypeCode> transportTypeToTransportTypeCodeMap = new HashMap<String, SntTransportTypeCode>();

    public static List<String> sectionCodeToProductTypes(Collection<SntSectionCode> sntSectionCodes) {
        if (CollectionUtils.isNotEmpty(sntSectionCodes)) {
            return sntSectionCodes.stream().map(sectionCodeProductTypeMap::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<SntSectionCode> productTypesToSectionCodes(Collection<String> productTypes) {
        if (CollectionUtils.isNotEmpty(productTypes)) {
            return productTypes.stream().map(productTypeSectionCodeMap::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void fillProductIdx(AbstractSnt snt) {
        for (SntAbstractProductSet sntAbstractProductSet : snt.getProductSets()) {
            if (!CollectionUtils.isNotEmpty(sntAbstractProductSet.getProducts())) continue;
            for (int i = 0; i < sntAbstractProductSet.getProducts().size(); ++i) {
                SntAbstractProduct product = sntAbstractProductSet.getProducts().get(i);
                product.setIdx(i);
            }
        }
    }

    public static List<String> transportTypeCodeToTransportTypes(Collection<SntTransportTypeCode> sntTransportTypeCodes) {
        if (CollectionUtils.isNotEmpty(sntTransportTypeCodes)) {
            return sntTransportTypeCodes.stream().map(transportTypeCodeToTransportTypeMap::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<SntTransportTypeCode> transportTypesToTransportTypeCodes(Collection<String> sntTransportType) {
        if (CollectionUtils.isNotEmpty(sntTransportType)) {
            return sntTransportType.stream().map(transportTypeToTransportTypeCodeMap::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static SntTransportTypeCode getCodeByTransportType(String transportTypeName) {
        return transportTypeToTransportTypeCodeMap.get(transportTypeName);
    }

    public static String getCustomerName(AbstractSnt snt) {
        if (snt instanceof SntV1) {
            return LambdaUtils.nullSafeApplyFunction((SntV1)snt, s -> s.getCustomer().getName());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getCustomerRegisterCountryCode(AbstractSnt snt) {
        if (snt instanceof SntV1) {
            return LambdaUtils.nullSafeApplyFunction((SntV1)snt, s -> s.getCustomer().getRegisterCountryCode());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static String getSellerName(AbstractSnt snt) {
        if (snt instanceof SntV1) {
            return LambdaUtils.nullSafeApplyFunction((SntV1)snt, s -> s.getSeller().getName());
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static boolean isExportTypeEqualsExport(AbstractSnt snt) {
        if (snt instanceof SntV1) {
            return LambdaUtils.nullSafeApplyFunction((SntV1)snt, s -> s.getSntExport().getExportType()) == SntExportTypeV1.EXPORT;
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static boolean isExportTypeEqualsTemporaryImpotedExport(AbstractSnt snt) {
        if (snt instanceof SntV1) {
            return LambdaUtils.nullSafeApplyFunction((SntV1)snt, s -> s.getSntExport().getExportType()) == SntExportTypeV1.EXPORT_OF_TEMPORARY_IMPORTED_PRODUCT;
        }
        throw new InvoiceVersionNotFoundException();
    }

    public static boolean isExportTypeEqualsExportOrTemporaryImportedExport(AbstractSnt snt) {
        return SntHelper.isExportTypeEqualsExport(snt) || SntHelper.isExportTypeEqualsTemporaryImpotedExport(snt);
    }

    public static List<SntAttachedFile> getExportControlAttachments(AbstractSnt snt) {
        if (snt instanceof SntV1) {
            return LambdaUtils.nullSafeApplyFunction((SntV1)snt, s -> s.getExportControlProductSet().getPermitDocuments());
        }
        throw new InvoiceVersionNotFoundException();
    }

    static {
        productTypeSectionCodeMap.put(SntProductTypeV1.PRODUCT.name(), SntSectionCode.S_01);
        productTypeSectionCodeMap.put(SntProductTypeV1.ETHANOL.name(), SntSectionCode.S_02);
        productTypeSectionCodeMap.put(SntProductTypeV1.WINE_MATERIAL.name(), SntSectionCode.S_03);
        productTypeSectionCodeMap.put(SntProductTypeV1.BEER.name(), SntSectionCode.S_04);
        productTypeSectionCodeMap.put(SntProductTypeV1.ALCOHOL_EXCEPT_BEER.name(), SntSectionCode.S_05);
        productTypeSectionCodeMap.put(SntProductTypeV1.OIL.name(), SntSectionCode.S_06);
        productTypeSectionCodeMap.put(SntProductTypeV1.BIOFUEL.name(), SntSectionCode.S_07);
        productTypeSectionCodeMap.put(SntProductTypeV1.TOBACCO.name(), SntSectionCode.S_08);
        productTypeSectionCodeMap.put(SntProductTypeV1.OTHER_PRODUCT_WITH_DIGITAL_MARK.name(), SntSectionCode.S_09);
        productTypeSectionCodeMap.put(SntProductTypeV1.EXPORT_CONTROL_PRODUCT.name(), SntSectionCode.S_10);
        sectionCodeProductTypeMap.put(SntSectionCode.S_01, SntProductTypeV1.PRODUCT.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_02, SntProductTypeV1.ETHANOL.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_03, SntProductTypeV1.WINE_MATERIAL.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_04, SntProductTypeV1.BEER.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_05, SntProductTypeV1.ALCOHOL_EXCEPT_BEER.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_06, SntProductTypeV1.OIL.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_07, SntProductTypeV1.BIOFUEL.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_08, SntProductTypeV1.TOBACCO.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_09, SntProductTypeV1.OTHER_PRODUCT_WITH_DIGITAL_MARK.name());
        sectionCodeProductTypeMap.put(SntSectionCode.S_10, SntProductTypeV1.EXPORT_CONTROL_PRODUCT.name());
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.AUTOMOBILE.name(), SntTransportTypeCode.TT_01);
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.RAILWAY.name(), SntTransportTypeCode.TT_02);
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.AIR.name(), SntTransportTypeCode.TT_03);
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.MARINE.name(), SntTransportTypeCode.TT_04);
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.PIPELINE.name(), SntTransportTypeCode.TT_05);
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.MULTIMODAL.name(), SntTransportTypeCode.TT_06);
        transportTypeToTransportTypeCodeMap.put(SntTransportTypeV1.OTHER.name(), SntTransportTypeCode.TT_07);
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_01, SntTransportTypeV1.AUTOMOBILE.name());
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_02, SntTransportTypeV1.RAILWAY.name());
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_03, SntTransportTypeV1.AIR.name());
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_04, SntTransportTypeV1.MARINE.name());
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_05, SntTransportTypeV1.PIPELINE.name());
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_06, SntTransportTypeV1.MULTIMODAL.name());
        transportTypeCodeToTransportTypeMap.put(SntTransportTypeCode.TT_07, SntTransportTypeV1.OTHER.name());
    }
}

