/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.esf.model.snt.SntParticipantType;
import ru.uss.esf.model.snt.version.v1.SntAlcoholBeerProductV1;
import ru.uss.esf.model.snt.version.v1.SntAlcoholExceptBeerProductV1;
import ru.uss.esf.model.snt.version.v1.SntBiofuelProductV1;
import ru.uss.esf.model.snt.version.v1.SntEthanolProductV1;
import ru.uss.esf.model.snt.version.v1.SntExportControlProductV1;
import ru.uss.esf.model.snt.version.v1.SntOilProductV1;
import ru.uss.esf.model.snt.version.v1.SntOtherProductWithDigitalMarkV1;
import ru.uss.esf.model.snt.version.v1.SntProductV1;
import ru.uss.esf.model.snt.version.v1.SntTobaccoProductV1;
import ru.uss.esf.model.snt.version.v1.SntTransportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.model.snt.version.v1.SntWineMaterialProductV1;
import ru.uss.esf.model.usermng.UserProfileInfo;

public class SntV1Helper {
    private static final Logger logger = LoggerFactory.getLogger(SntV1Helper.class);
    public static final List<String> ALCOHOL_RETAIL_OPERATION_CODES = Collections.unmodifiableList(Arrays.asList("7", "10"));

    public static boolean hasAllOilProductWith34(SntV1 sntV1) {
        List sntOilProducts = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getOilSet().getProducts(), Collections.emptyList());
        long filteredCount = sntOilProducts.stream().map(SntOilProductV1::getPinCode).filter(s -> {
            int length = StringUtils.length((CharSequence)s);
            if (length > 4) {
                char charAt = s.charAt(length - 4);
                return charAt == '3' || charAt == '4';
            }
            return false;
        }).count();
        return CollectionUtils.isNotEmpty(sntOilProducts) && filteredCount == (long)sntOilProducts.size();
    }

    public static boolean hasAnyProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG1Products(sntV1);
    }

    public static boolean hasAnyAlcoholProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG2Products(sntV1) || SntV1Helper.hasAnyG3Products(sntV1) || SntV1Helper.hasAnyG4Products(sntV1) || SntV1Helper.hasAnyG5Products(sntV1);
    }

    public static boolean hasAnyEthanolProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG2Products(sntV1);
    }

    public static boolean hasAnyWineMaterialProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG3Products(sntV1);
    }

    public static boolean hasAnyAlcoholBeerProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG4Products(sntV1);
    }

    public static boolean hasAnyAlcoholExceptBeerProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG5Products(sntV1);
    }

    public static boolean hasAnyOilProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG6Products(sntV1);
    }

    public static boolean hasAnyBiofuelProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG7Products(sntV1);
    }

    public static boolean hasAnyTobaccoProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG8Products(sntV1);
    }

    public static boolean hasAnyOtherWithDigitalMarkProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG10Products(sntV1);
    }

    public static boolean hasAnyExportControlProducts(SntV1 sntV1) {
        return SntV1Helper.hasAnyG11Products(sntV1);
    }

    public static boolean hasAnyG1Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG1Products(sntV1));
    }

    public static List<SntProductV1> getG1Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getProductSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG2Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG2Products(sntV1));
    }

    public static List<SntEthanolProductV1> getG2Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getEthanolProductSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG3Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG3Products(sntV1));
    }

    public static List<SntWineMaterialProductV1> getG3Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getWineMaterialProductSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG4Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG4Products(sntV1));
    }

    public static List<SntAlcoholBeerProductV1> getG4Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholBeerProductSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG5Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG5Products(sntV1));
    }

    public static List<SntAlcoholExceptBeerProductV1> getG5Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholExceptBeerProductSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG6Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG6Products(sntV1));
    }

    public static List<SntOilProductV1> getG6Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getOilSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG7Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG7Products(sntV1));
    }

    public static List<SntBiofuelProductV1> getG7Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getBiofuelSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG8Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG8Products(sntV1));
    }

    public static List<SntTobaccoProductV1> getG8Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getTobaccoSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG10Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG10Products(sntV1));
    }

    public static List<SntOtherProductWithDigitalMarkV1> getG10Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getOtherProductWithDigitalMarkSet().getProducts(), Collections.emptyList());
    }

    public static boolean hasAnyG11Products(SntV1 sntV1) {
        return CollectionUtils.isNotEmpty(SntV1Helper.getG11Products(sntV1));
    }

    public static List<SntExportControlProductV1> getG11Products(SntV1 sntV1) {
        return LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getExportControlProductSet().getProducts(), Collections.emptyList());
    }

    public static boolean isAlcoholG45WithRetailCode(SntV1 sntV1) {
        if (sntV1.getAlcoholSet() != null) {
            if (sntV1.getAlcoholSet().getAlcoholBeerProductSet() != null && ALCOHOL_RETAIL_OPERATION_CODES.contains(sntV1.getAlcoholSet().getAlcoholBeerProductSet().getOperationCode())) {
                return true;
            }
            if (sntV1.getAlcoholSet().getAlcoholExceptBeerProductSet() != null && ALCOHOL_RETAIL_OPERATION_CODES.contains(sntV1.getAlcoholSet().getAlcoholExceptBeerProductSet().getOperationCode())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isActiveParticipant(SntV1 snt, UserProfileInfo userProfileInfo, SntParticipantType participantType) {
        Long currentUserProjectCode = userProfileInfo.getProjectCode();
        String currentTin = userProfileInfo.getCurrentTin();
        if (currentUserProjectCode == null) {
            if (SntParticipantType.SENDER.equals((Object)participantType) && snt.getSenderAndBranchTins().contains(currentTin)) {
                return true;
            }
            if (SntParticipantType.RECIPIENT.equals((Object)participantType) && snt.getRecipientAndBranchTins().contains(currentTin)) {
                return true;
            }
        } else {
            if (SntParticipantType.SENDER.equals((Object)participantType) && currentUserProjectCode.equals(snt.getSellerProjectCode())) {
                return userProfileInfo.isAttorney() || userProfileInfo.isOperator();
            }
            if (currentUserProjectCode.equals(snt.getCustomerProjectCode())) {
                return userProfileInfo.isAttorney() || userProfileInfo.isOperator();
            }
        }
        return false;
    }

    public static boolean isSntTransportTypeNullOrPipe(SntV1 snt) {
        List sntTransportTypes = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getShippingInfo().getTransportTypes());
        if (CollectionUtils.isEmpty((Collection)sntTransportTypes)) {
            return true;
        }
        return sntTransportTypes.size() == 1 && SntTransportTypeV1.PIPELINE.equals(sntTransportTypes.get(0));
    }
}

