/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.math.BigDecimal;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.BigDecimalCheck;

public class BigDecimalValidator
extends AbstractFieldLevelValidator<BigDecimalCheck, BigDecimal> {
    private String fieldPath;
    private boolean nullable;
    private int maxLeftLen;
    private int maxRightLen;

    public void initialize(BigDecimalCheck constraint) {
        this.fieldPath = constraint.fieldPath();
        this.nullable = constraint.nullable();
        this.maxLeftLen = constraint.maxLeftLen();
        this.maxRightLen = constraint.maxRightLen();
    }

    public boolean isValid(BigDecimal value, ConstraintValidatorContext context) {
        if (!this.nullable && value == null) {
            return this.setupContextWithValidationError(context, this.generateNotNullFieldMessage(this.fieldPath));
        }
        if (value != null) {
            int valueLeftLen = value.precision() - value.scale();
            int valueRightLen = value.scale();
            if (valueLeftLen > this.maxLeftLen || valueRightLen > this.maxRightLen) {
                return this.setupContextWithValidationError(context, this.generateSizeOverflowFieldMessage(this.fieldPath));
            }
        }
        return true;
    }

    private String generateSizeOverflowFieldMessage(String fieldPath) {
        return "\u041f\u043e\u043b\u0435 '{" + fieldPath + "}' {decimalConstraint}";
    }
}

