/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import ru.uss.core.validation.common.PathInfo;

public class FieldUtils {
    public static boolean fieldNotEmpty(Object fieldValue, String path) {
        return FieldUtils.fieldNotEmpty(fieldValue, path, new PathInfo());
    }

    public static boolean fieldNotEmpty(Object object, String fieldPath, PathInfo pathInfo) {
        String head;
        int dotIndex = fieldPath.indexOf(".");
        String tail = null;
        if (dotIndex < 0) {
            head = fieldPath;
        } else {
            head = fieldPath.substring(0, dotIndex);
            tail = fieldPath.substring(dotIndex + 1);
        }
        pathInfo.addToLast(head);
        object = FieldUtils.getFieldValue(object, head);
        if (object == null) {
            return false;
        }
        if (tail == null) {
            if (object instanceof Collection) {
                return !((Collection)object).isEmpty();
            }
            return !object.toString().isEmpty();
        }
        if (object instanceof Collection) {
            Collection fieldCollection = (Collection)object;
            if (!fieldCollection.isEmpty()) {
                String prefix = pathInfo.getLast();
                pathInfo.removeLast();
                int i = 0;
                for (Object e : fieldCollection) {
                    pathInfo.add(prefix + "[" + i + "].");
                    if (e == null || !FieldUtils.fieldNotEmpty(e, tail, pathInfo)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        } else {
            pathInfo.addToLast(".");
            return FieldUtils.fieldNotEmpty(object, tail, pathInfo);
        }
        return false;
    }

    public static Object getFieldValue(Object bean, String fieldName) {
        if (bean == null) {
            throw new IllegalArgumentException("Argument bean is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Argument fieldName is null");
        }
        if (fieldName.isEmpty()) {
            return bean;
        }
        try {
            Method method;
            String methodName = FieldUtils.composeGetterName(fieldName);
            try {
                method = bean.getClass().getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                methodName = FieldUtils.composeBooleanGetterName(fieldName);
                method = bean.getClass().getMethod(methodName, new Class[0]);
            }
            return method.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Can't access " + fieldName + " field", ex);
        }
    }

    private static String composeGetterName(String name) {
        return FieldUtils.composeGetterName("get", name);
    }

    private static String composeBooleanGetterName(String name) {
        return FieldUtils.composeGetterName("is", name);
    }

    private static String composeGetterName(String prefix, String fieldName) {
        return prefix + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }
}

