/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.math.BigDecimal;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.BigDecimalUtils;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.PositiveOrZero;

public class PositiveOrZeroValidator
extends AbstractFieldLevelValidator<PositiveOrZero, Number> {
    private PositiveOrZero annotation;

    public void initialize(PositiveOrZero annotation) {
        this.annotation = annotation;
    }

    public boolean isValid(Number number, ConstraintValidatorContext constraintValidatorContext) {
        if (number != null && BigDecimalUtils.lessThanZero(BigDecimal.valueOf(number.doubleValue()))) {
            if (StringUtils.isNotEmpty((CharSequence)this.annotation.fieldPath())) {
                return this.setupContextWithValidationError(constraintValidatorContext, "{field} '{" + this.annotation.fieldPath() + "}' {positiveOrZero}");
            }
            return this.setupContextWithValidationError(constraintValidatorContext, this.annotation.message());
        }
        return true;
    }
}

