/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.RequiredString;

public class RequiredStringValidator
extends AbstractFieldLevelValidator<RequiredString, String> {
    protected String fieldPath;
    protected int minLen;
    protected int maxLen;
    protected boolean required;

    public void initialize(RequiredString constraintAnnotation) {
        this.fieldPath = constraintAnnotation.fieldPath();
        this.minLen = constraintAnnotation.minLen();
        this.maxLen = constraintAnnotation.maxLen();
        this.required = constraintAnnotation.required();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            if (this.required) {
                return this.setupContextWithValidationError(context, this.generateNotNullFieldMessage(this.fieldPath));
            }
            return true;
        }
        int valueLength = value.length();
        String messageTemplate = "\u041f\u043e\u043b\u0435 '{" + this.fieldPath + "}' {requiredLength}";
        if (this.minLen > valueLength) {
            return this.setupContextWithValidationError(context, messageTemplate);
        }
        if (this.maxLen < valueLength) {
            List<String> sntStateNumberFields = Arrays.asList("sntShippingInfoV1.carStateNumber", "sntShippingInfoV1.trailerStateNumber", "sntOgdMarksV1.carStateNumber");
            if (sntStateNumberFields.contains(this.fieldPath)) {
                messageTemplate = "{maximumStateNumberLength}";
            }
            return this.setupContextWithValidationError(context, messageTemplate);
        }
        return true;
    }
}

