/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.cert;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.cert.CertProductSet;
import ru.uss.esf.model.cert.CertificateForm;
import ru.uss.esf.model.cert.CertificateStatus;
import ru.uss.esf.model.cert.ESSCertificateValidationGroups;
import ru.uss.esf.validation.cert.CertProductsCheck;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.common.relation.TextLengthIfTagretFieldContains;

@CertProductsCheck
@NotEmptyIfTargetFieldContains.List(value={@NotEmptyIfTargetFieldContains(checkedField="senderTin", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.senderTin.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="senderName", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.senderName.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="senderAddress", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.senderAddress.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="fromCountry", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.fromCountry.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="transportType", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.transportType.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="certificateOriginCountry", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.certificateOriginCountry.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="invoiceDateNum", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.invoiceDateNum.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="destinationPoint", targetField="form", expectedValues={"CT01"}, message="{ess.certificate.destinationPoint.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="aim", targetField="form", expectedValues={"CTKZ"}, message="{ess.certificate.aim.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="expireDate", targetField="form", expectedValues={"CTKZ"}, message="{ess.certificate.expireDate.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="manufacturerTin", targetField="form", expectedValues={"CTKZ"}, message="{ess.certificate.manufacturerTin.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="manufacturerName", targetField="form", expectedValues={"CTKZ"}, message="{ess.certificate.manufacturerName.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="manufacturerAddress", targetField="form", expectedValues={"CTKZ"}, message="{ess.certificate.manufacturerAddress.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="certificateCategory", targetField="form", expectedValues={"CTKZ"}, message="{ess.certificate.certificateCategory.notNull}"), @NotEmptyIfTargetFieldContains(checkedField="toCountry", targetField="hasEA", expectedValues={"false"}, message="{ess.certificate.toCountry.notNull}", groups={ESSCertificateValidationGroups.CT01Certificate.class})})
@TextLengthIfTagretFieldContains.List(value={@TextLengthIfTagretFieldContains(checkedField="number", targetField="form", expectedValue="CTKZ", min=11, max=11, message="{ess.certificate.number.length}"), @TextLengthIfTagretFieldContains(checkedField="number", targetField="form", expectedValue="CT01", min=13, max=13, message="{ess.certificate.number.length}")})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="SaveCertificateRequest")
@XmlType(name="SaveCertificateRequest")
@Documentation(value="\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430\u0445 CT-KZ, CT\u20131 c \u042d\u0421\u0421")
public class SaveCertificateRequest
implements Serializable {
    @IsNotNull(fieldPath="ess.certificate.form")
    @XmlElement(required=true)
    @Documentation(value="\u0424\u043e\u0440\u043c\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430")
    private CertificateForm form;
    @IsNotNull(fieldPath="ess.certificate.number")
    @RequiredString(minLen=11, maxLen=13, fieldPath="ess.certificate.number")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f")
    private String number;
    @IsNotNull(fieldPath="ess.certificate.issueDate")
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438")
    private Date issueDate;
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430")
    private String fromCountry;
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0442\u0440\u0430\u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f/\u0438\u043c\u043f\u043e\u0440\u0442\u0435\u0440\u0430")
    private String toCountry;
    @Tin(message="{ess.certificate.manufacturerTin.format}")
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f")
    private String manufacturerTin;
    @RequiredString(maxLen=600, fieldPath="ess.certificate.manufacturerName", required=false)
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f")
    private String manufacturerName;
    @RequiredString(maxLen=600, fieldPath="ess.certificate.manufacturerAddress", required=false)
    @XmlElement(required=false)
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f")
    private String manufacturerAddress;
    @RequiredString(maxLen=600, fieldPath="ess.certificate.rppName")
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0420\u041f\u041f")
    private String rppName;
    @RequiredString(maxLen=3, fieldPath="ess.certificate.rppCode")
    @Pattern(regexp="[0-9]{3}", message="{ess.certificate.rppCode.size}")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u0420\u041f\u041f")
    private @Pattern(regexp="[0-9]{3}", message="{ess.certificate.rppCode.size}") String rppCode;
    @RequiredString(maxLen=600, fieldPath="ess.certificate.certificateCategory", required=false)
    @XmlElement(required=false)
    @Documentation(value="\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430")
    private String certificateCategory;
    @RequiredString(maxLen=50, fieldPath="ess.certificate.blankNumber")
    @XmlElement(required=false)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0431\u043b\u0430\u043d\u043a\u0430")
    private String blankNumber;
    @IsNotNull(fieldPath="ess.certificate.productSet")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0442\u043e\u0432\u0430\u0440\u0430\u0445")
    private CertProductSet productSet;
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430")
    private CertificateStatus status;
    @Tin(message="{ess.certificate.senderTin.format}")
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f/\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0435\u0440\u0430")
    private String senderTin;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f/\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0435\u0440\u0430")
    private String senderName;
    @XmlElement(required=false)
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f/\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0435\u0440\u0430")
    private String senderAddress;
    @XmlElement(required=false)
    @Documentation(value="\u0426\u0435\u043b\u044c \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430")
    private String aim;
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430")
    private Date expireDate;
    @XmlTransient
    @Documentation(value="Id \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f")
    private UUID messageId;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u0437\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f/\u0438\u043c\u043f\u043e\u0440\u0442\u0435\u0440\u0430")
    private String recipientName;
    @XmlElement(required=false)
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u0433\u0440\u0443\u0437\u043e\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f/\u0438\u043c\u043f\u043e\u0440\u0442\u0435\u0440\u0430")
    private String recipientAddress;
    @XmlElement(required=false)
    @Documentation(value="\u0412\u0438\u0434 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430")
    private String transportType;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0443\u043d\u043a\u0442 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f (\u0441\u0442\u0430\u043d\u0446\u0438\u044f)")
    private String destinationPoint;
    @Documentation(value="\u041f\u0443\u043d\u043a\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f")
    private String departurePoint;
    @Documentation(value="\u0421\u0442\u0440\u0430\u043d\u0430, \u0432\u044b\u0434\u0430\u0432\u0448\u0430\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442")
    private String certificateOriginCountry;
    @Documentation(value="\u0414\u0430\u0442\u0430/\u041d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b")
    private String invoiceDateNum;
    @Documentation(value="\u0414\u043b\u044f \u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0445 \u043e\u0442\u043c\u0435\u0442\u043e\u043a")
    private String note;

    public CertificateForm getForm() {
        return this.form;
    }

    public void setForm(CertificateForm form) {
        this.form = form;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public String getFromCountry() {
        return this.fromCountry;
    }

    public void setFromCountry(String fromCountry) {
        this.fromCountry = fromCountry;
    }

    public String getToCountry() {
        return this.toCountry;
    }

    public void setToCountry(String toCountry) {
        this.toCountry = toCountry;
    }

    public String getManufacturerTin() {
        return this.manufacturerTin;
    }

    public void setManufacturerTin(String manufacturerTin) {
        this.manufacturerTin = manufacturerTin;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getManufacturerAddress() {
        return this.manufacturerAddress;
    }

    public void setManufacturerAddress(String manufacturerAddress) {
        this.manufacturerAddress = manufacturerAddress;
    }

    public String getRppName() {
        return this.rppName;
    }

    public void setRppName(String rppName) {
        this.rppName = rppName;
    }

    public String getRppCode() {
        return this.rppCode;
    }

    public void setRppCode(String rppCode) {
        this.rppCode = rppCode;
    }

    public String getCertificateCategory() {
        return this.certificateCategory;
    }

    public void setCertificateCategory(String certificateCategory) {
        this.certificateCategory = certificateCategory;
    }

    public String getBlankNumber() {
        return this.blankNumber;
    }

    public void setBlankNumber(String blankNumber) {
        this.blankNumber = blankNumber;
    }

    public CertProductSet getProductSet() {
        return this.productSet;
    }

    public void setProductSet(CertProductSet productSet) {
        this.productSet = productSet;
    }

    public CertificateStatus getStatus() {
        return this.status;
    }

    public void setStatus(CertificateStatus status) {
        this.status = status;
    }

    public String getSenderTin() {
        return this.senderTin;
    }

    public void setSenderTin(String senderTin) {
        this.senderTin = senderTin;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    public String getAim() {
        return this.aim;
    }

    public void setAim(String aim) {
        this.aim = aim;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public UUID getMessageId() {
        return this.messageId;
    }

    public void setMessageId(UUID messageId) {
        this.messageId = messageId;
    }

    public boolean getHasEA() {
        return this.number != null && "EA".equals(this.number.substring(2, 4));
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public String getCertificateOriginCountry() {
        return this.certificateOriginCountry;
    }

    public void setCertificateOriginCountry(String certificateOriginCountry) {
        this.certificateOriginCountry = certificateOriginCountry;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public void setTransportType(String transportType) {
        this.transportType = transportType;
    }

    public String getDestinationPoint() {
        return this.destinationPoint;
    }

    public void setDestinationPoint(String destinationPoint) {
        this.destinationPoint = destinationPoint;
    }

    public String getDeparturePoint() {
        return this.departurePoint;
    }

    public void setDeparturePoint(String departurePoint) {
        this.departurePoint = departurePoint;
    }

    public String getInvoiceDateNum() {
        return this.invoiceDateNum;
    }

    public void setInvoiceDateNum(String invoiceDateNum) {
        this.invoiceDateNum = invoiceDateNum;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }
}

