/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.dictionary;

import java.util.Arrays;
import java.util.List;

public enum EnterpriseState {
    NOT_SET(0),
    WORK(1),
    FAKE(2),
    IDLE(3),
    BANKRUPT(4);

    private static final List<String> FAKE_UNREG_REASONS;
    private byte stateId;

    private EnterpriseState(byte stateId) {
        this.stateId = stateId;
    }

    public static EnterpriseState getStateById(byte stateId) {
        for (EnterpriseState state : EnterpriseState.values()) {
            if (state.getStateId() != stateId) continue;
            return state;
        }
        throw new IllegalArgumentException("Unknown enterprise state identifier - " + stateId);
    }

    public static EnterpriseState parseNkStatus(String nkStatus, String unregReason) {
        EnterpriseState result = null;
        switch (nkStatus) {
            case "FORMED": {
                result = IDLE;
                break;
            }
            case "IS_VALID": {
                result = WORK;
                break;
            }
            case "SUSPENDED": 
            case "NON_VALID": {
                result = EnterpriseState.isEnterpriseWithoutVat(unregReason) ? NOT_SET : FAKE;
                break;
            }
            case "REPLACED": {
                result = IDLE;
            }
        }
        return result;
    }

    private static boolean isEnterpriseWithoutVat(String unregReason) {
        return !FAKE_UNREG_REASONS.contains(unregReason);
    }

    public byte getStateId() {
        return this.stateId;
    }

    static {
        FAKE_UNREG_REASONS = Arrays.asList("VIOLATION_OF_BUSINESS_MATTER", "INIS_ACTIVITY_CLOSED", "INIS_LIQUIDATION", "INIS_INSOLVENCY", "INIS_DECEASE");
    }
}

