/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.dictionary;

import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.dictionary.PersonType;
import ru.uss.esf.model.transit.TransitType;

@XmlType(name="TaxpayerMark")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430")
public class TaxpayerMark {
    @IsNotNull(fieldPath="taxpayerMark.target")
    @Documentation(value="\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435")
    private Target target;
    @RequiredString(required=true, minLen=1, maxLen=50, fieldPath="taxpayerMark.tin")
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u041d\u041f")
    private String tin;
    @RequiredString(required=true, minLen=1, maxLen=40, fieldPath="taxpayerMark.mark")
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a")
    private String mark;
    @Size(min=1, message="{taxpayerMark.directionSet.empty}")
    @Documentation(value="\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435")
    private @Size(min=1, message="{taxpayerMark.directionSet.empty}") Set<TransitType> directionSet;
    @Size(min=1, message="{taxpayerMark.taxpayerTypeSet.empty}")
    @Documentation(value="\u0422\u0438\u043f \u041d\u041f")
    private @Size(min=1, message="{taxpayerMark.taxpayerTypeSet.empty}") Set<PersonType> taxpayerTypeSet;
    @XmlTransient
    private String directionLine;
    @XmlTransient
    private String taxpayerTypeLine;
    private String taxpayerKey;
    private String taxpayerError;

    public String getTaxpayerError() {
        return this.taxpayerError;
    }

    public void setTaxpayerError(String taxpayerError) {
        this.taxpayerError = taxpayerError;
    }

    public boolean isTaxpayerError() {
        return this.getTaxpayerError() != null && !this.getTaxpayerError().equals("");
    }

    public String getTaxpayerKey() {
        return this.taxpayerKey;
    }

    public void setTaxpayerKey() {
        this.taxpayerKey = this.getTin() + (Object)((Object)this.getTarget()) + this.getMark();
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getMark() {
        return this.mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public Set<TransitType> getDirectionSet() {
        return this.directionSet;
    }

    public void setDirectionSet(Set<TransitType> directionSet) {
        this.directionSet = directionSet;
    }

    public Set<PersonType> getTaxpayerTypeSet() {
        return this.taxpayerTypeSet;
    }

    public void setTaxpayerTypeSet(Set<PersonType> taxpayerTypeSet) {
        this.taxpayerTypeSet = taxpayerTypeSet;
    }

    public String getDirectionLine() {
        return this.directionLine;
    }

    public void setDirectionLine(String directionLine) {
        this.directionLine = directionLine;
    }

    public String getTaxpayerTypeLine() {
        return this.taxpayerTypeLine;
    }

    public void setTaxpayerTypeLine(String taxpayerTypeLine) {
        this.taxpayerTypeLine = taxpayerTypeLine;
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.tin) && StringUtils.isBlank((CharSequence)this.mark) && CollectionUtils.isEmpty(this.directionSet) && CollectionUtils.isEmpty(this.taxpayerTypeSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxpayerMark that = (TaxpayerMark)o;
        return Objects.equals(this.tin, that.tin);
    }

    public int hashCode() {
        return Objects.hash(this.tin);
    }

    @Documentation(value="\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0437\u043d\u0430\u043a\u0430")
    public static enum Target {
        TRANSIT;

    }
}

