/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.econtract;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.model.DocumentInfo;
import ru.uss.core.model.DocumentType;
import ru.uss.core.model.Error;
import ru.uss.core.model.SignableDocument;
import ru.uss.core.model.SignatureType;
import ru.uss.core.model.TypedDocument;
import ru.uss.core.model.VersionedDocument;
import ru.uss.esf.model.econtract.EcontractInitiator;
import ru.uss.esf.model.econtract.EcontractParticipantStatus;
import ru.uss.esf.model.econtract.EcontractParticipantType;
import ru.uss.esf.model.econtract.EcontractStatus;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontract;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontractParticipant;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EcontractInfo")
@Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u043c\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443")
@JsonIgnoreProperties(ignoreUnknown=true)
public class EcontractInfo
implements Serializable,
SignableDocument,
DocumentInfo,
TypedDocument,
VersionedDocument {
    @XmlElement
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u042d\u0414 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435")
    private Long econtractId;
    @XmlElement(required=true, nillable=true)
    @Documentation(value="\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 (xml)")
    private String econtractBody;
    @XmlTransient
    @Documentation(value="\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440")
    private AbstractEcontract econtract;
    @XmlElement(required=true)
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0438\u043d\u0438\u0446\u0438\u0430\u0442\u043e\u0440\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private EcontractInitiator initiator;
    @XmlTransient
    @Documentation(value="\u041e\u0448\u0438\u0431\u043a\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 (\u0424\u041b\u041a) \u042d\u0414")
    private List<Error> errors = new ArrayList<Error>();
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f \u042d\u0414 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Date inputDate;
    @XmlElement
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u042d\u0414")
    private String registrationNumber;
    @XmlElement(required=true)
    @Documentation(value="\u0412\u0435\u0440\u0441\u0438\u044f \u042d\u0414")
    private String version;
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u042d\u0414")
    private EcontractStatus status;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u044f/\u043e\u0442\u0437\u044b\u0432\u0430/\u043e\u0448\u0438\u0431\u043a\u0438")
    private String cancelReason;
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u042d\u0414")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy HH:mm:ss")
    private Date lastUpdateDate;
    @JsonInclude
    @XmlElement(required=true)
    @Documentation(value="\u041f\u043e\u0434\u043f\u0438\u0441\u044c XML-\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u042d\u0414")
    private String signature;
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u042d\u0426\u041f, \u043a\u043e\u0442\u043e\u0440\u044b\u043c \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d \u042d\u0414")
    private SignatureType signatureType;
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u0430\u043a\u0436\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 \u2014 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0438 \u0441\u043e\u0437\u0434\u0430\u043b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442")
    private String certificate;
    @JsonIgnore
    @XmlTransient
    @Documentation(value="\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438")
    private String certificateSerialNumber;
    @XmlElement
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u043f\u0440\u0430\u0432")
    private boolean cessionOfRights;
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438")
    private boolean signatureValid;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c \u0441\u0440\u043e\u043a\u043e\u0432")
    private Boolean timeControl;
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0432 \u0422\u0420\u0423")
    private Boolean hasServices;
    @JsonIgnore
    @XmlTransient
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0443\u0447\u0430\u0442\u0441\u043d\u0438\u043a\u0430 (\u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u0441\u0435\u0441\u0441\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430)")
    private EcontractParticipantStatus currentParticipantStatus;

    public Long getEcontractId() {
        return this.econtractId;
    }

    public void setEcontractId(Long econtractId) {
        this.econtractId = econtractId;
    }

    public String getEcontractBody() {
        return this.econtractBody;
    }

    public void setEcontractBody(String econtractBody) {
        this.econtractBody = econtractBody;
    }

    public AbstractEcontract getEcontract() {
        return this.econtract;
    }

    public void setEcontract(AbstractEcontract econtract) {
        this.econtract = econtract;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    @Override
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCurrentParticipantStatus(EcontractParticipantStatus currentParticipantStatus) {
        this.currentParticipantStatus = currentParticipantStatus;
    }

    public Boolean isTimeControl() {
        return this.timeControl;
    }

    public void setTimeControl(Boolean timeControl) {
        this.timeControl = timeControl;
    }

    public EcontractParticipantStatus getCurrentParticipantStatus() {
        return this.currentParticipantStatus;
    }

    public EcontractStatus getStatus() {
        return this.status;
    }

    public void setStatus(EcontractStatus status) {
        this.status = status;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    public void setSignatureValid(boolean signatureValid) {
        this.signatureValid = signatureValid;
    }

    public boolean isCessionOfRights() {
        return this.cessionOfRights;
    }

    public void setCessionOfRights(boolean cessionOfRights) {
        this.cessionOfRights = cessionOfRights;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public EcontractInitiator getInitiator() {
        return this.initiator;
    }

    public void setInitiator(EcontractInitiator initiator) {
        this.initiator = initiator;
    }

    public String getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public void setCertificateSerialNumber(String certificateSerialNumber) {
        this.certificateSerialNumber = certificateSerialNumber;
    }

    public Boolean getTimeControl() {
        return this.timeControl;
    }

    public Boolean getHasServices() {
        return this.hasServices;
    }

    public void setHasServices(Boolean hasServices) {
        this.hasServices = hasServices;
    }

    @Override
    public Long getDocumentId() {
        return this.econtractId;
    }

    @Override
    public String getDocumentBody() {
        return this.econtractBody;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public Date getSigningDate() {
        return this.inputDate;
    }

    public boolean isInitiator(AbstractEcontractParticipant participant) {
        return this.isInitiatingParty(participant) && participant.getTin().equals(this.getInitiator().getTin());
    }

    public boolean isInitiatingParty(AbstractEcontractParticipant participant) {
        return participant != null && participant.getType().equals((Object)this.getInitiator().getInitiatingParty());
    }

    public boolean isInitiatingParty(String tin) {
        return !StringUtils.isEmpty((CharSequence)tin) && this.getInitiator().getInitiatingParty().equals((Object)this.getParticipantType(tin));
    }

    public EcontractParticipantType getParticipantType(String tin) {
        return this.econtract.getSupplierTinList().contains(tin) ? EcontractParticipantType.SUPPLIER : (this.econtract.getCustomerTinList().contains(tin) ? EcontractParticipantType.CUSTOMER : null);
    }

    public boolean isCreatorSingleOnInitiatingParty() {
        return this.getParticipants(this.getInitiator().getInitiatingParty()).size() == 1;
    }

    public List<? extends AbstractEcontractParticipant> getParticipants(EcontractParticipantType type) {
        return this.econtract.getParticipants().stream().filter(p -> p.getType().equals((Object)type)).collect(Collectors.toList());
    }

    @Override
    public DocumentType getDocumentType() {
        return DocumentType.ECONTRACT;
    }

    @JsonProperty
    public String getEcontractIdAsString() {
        return this.econtractId != null ? String.valueOf(this.econtractId) : "";
    }
}

