/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.egp;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="EgpSubjectType")
@Documentation(value="\u0422\u0438\u043f \u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u043c\u044b\u0445 \u0440\u0430\u0431\u043e\u0442/\u0443\u0441\u043b\u0443\u0433/\u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u042d\u0413\u0417")
public enum EgpSubjectType {
    WORK("R", "6", 2L),
    SERVICE("S", "6", 3L),
    GOODS("G", "0", 1L);

    private final String subjectCode;
    private final String trueOriginCode;
    private final Long id;

    private EgpSubjectType(String subjectCode, String trueOriginCode, Long id) {
        this.trueOriginCode = trueOriginCode;
        this.subjectCode = subjectCode;
        this.id = id;
    }

    public String subjectCode() {
        return this.subjectCode;
    }

    public String getTrueOriginCode() {
        return this.trueOriginCode;
    }

    public static EgpSubjectType getSubjectType(String code) {
        if (EgpSubjectType.WORK.subjectCode.equals(code)) {
            return WORK;
        }
        if (EgpSubjectType.SERVICE.subjectCode.equals(code)) {
            return SERVICE;
        }
        return null;
    }

    public static EgpSubjectType getSubjectType(Long subjectTypeId) {
        if (EgpSubjectType.WORK.id.equals(subjectTypeId)) {
            return WORK;
        }
        if (EgpSubjectType.SERVICE.id.equals(subjectTypeId)) {
            return SERVICE;
        }
        if (EgpSubjectType.GOODS.id.equals(subjectTypeId)) {
            return GOODS;
        }
        return null;
    }
}

