/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.version.EsfVersion;

public class EsfVersions {
    public static final String V1 = "InvoiceV1";
    public static final String V2 = "InvoiceV2";
    public static final String CURRENT_DEFAULT_VERSION = "InvoiceV2";
    private static final Map<String, String> suffixMap = new HashMap<String, String>();
    private static final List<EsfVersion> ESF_VERSION_LIST = new ArrayList<EsfVersion>(2);
    private static final Map<String, EsfVersion> ESF_VERSION_MAP = new HashMap<String, EsfVersion>();

    public static String getSuffix(String version) {
        return suffixMap.get(version);
    }

    public static List<EsfVersion> getEsfVersionList() {
        return ESF_VERSION_LIST;
    }

    public static EsfVersion getEsfVersion(String version) {
        return ESF_VERSION_MAP.get(version);
    }

    public static String getEsfVersion(Date date) {
        Assert.notNull((Object)date);
        for (EsfVersion esfVersion : ESF_VERSION_LIST) {
            if (!DateTimeUtils.greaterOrEquals(date, esfVersion.getStartDate()) || esfVersion.getEndDate() != null && !DateTimeUtils.lessOrEquals(date, esfVersion.getEndDate())) continue;
            return esfVersion.getVersion();
        }
        return null;
    }

    static {
        suffixMap.put(V1, "V1");
        suffixMap.put("InvoiceV2", "V2");
        ESF_VERSION_LIST.add(new EsfVersion(V1, "01.01.2000", "01.01.2018", "V1"));
        ESF_VERSION_LIST.add(new EsfVersion("InvoiceV2", "02.01.2018", null, "V2"));
        ESF_VERSION_LIST.forEach(e -> ESF_VERSION_MAP.put(e.getVersion(), (EsfVersion)e));
    }
}

