/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version;

import java.util.HashMap;
import java.util.Map;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;

public class InvoiceVersionMapper {
    private static final Map<String, Class<? extends AbstractInvoice>> mapToClass = new HashMap<String, Class<? extends AbstractInvoice>>();
    private static final Map<Class<? extends AbstractInvoice>, String> mapToVersion = new HashMap<Class<? extends AbstractInvoice>, String>();

    public static Class<? extends AbstractInvoice> getClassByVersion(String version) {
        Class<? extends AbstractInvoice> invoiceClass = mapToClass.get(version);
        if (invoiceClass == null) {
            throw new IllegalStateException();
        }
        return invoiceClass;
    }

    public static AbstractInvoice getEmptyInstanceByVersion(String version) {
        switch (version) {
            case "InvoiceV1": {
                return new InvoiceV1();
            }
            case "InvoiceV2": {
                return new InvoiceV2();
            }
        }
        throw new IllegalStateException();
    }

    public static String getVersionByClass(AbstractInvoice invoice) {
        String invoiceVersion = mapToVersion.get(invoice.getClass());
        if (invoiceVersion == null) {
            throw new IllegalStateException();
        }
        return invoiceVersion;
    }

    static {
        mapToClass.put("InvoiceV1", InvoiceV1.class);
        mapToClass.put("InvoiceV2", InvoiceV2.class);
        mapToClass.forEach((e, c) -> mapToVersion.put((Class<? extends AbstractInvoice>)c, (String)e));
    }
}

