/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.ndsbc.ks;

import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.model.Error;
import ru.uss.core.model.ErrorCode;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="KsError")
@XmlType(name="KsError")
@Documentation(value="\u041e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438 \u043e\u0431\u0440\u043e\u0431\u043e\u0442\u043a\u0435")
public class KsError {
    @XmlTransient
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u043b\u0438 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0441\u0447\u0435\u0442\u0430")
    private String recordId;
    @XmlTransient
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 (\u0437\u0430\u043f\u0438\u0441\u0438)")
    private String recordNumber;
    @XmlTransient
    @Documentation(value="\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 (\u0437\u0430\u043f\u0438\u0441\u0438)")
    private String recordType;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u043e\u043b\u0435 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430")
    private String property;
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String errorCode;
    @XmlElement(required=false)
    @Documentation(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String errorDescription;

    public KsError() {
    }

    public KsError(String recordId, String recordNumber, String recordType, ErrorCode errorCode, String errorDescription) {
        this.recordId = recordId;
        this.recordNumber = recordNumber;
        this.recordType = recordType;
        this.errorCode = errorCode != null ? errorCode.name() : ErrorCode.FIELD_INVALID.name();
        this.errorDescription = errorDescription;
    }

    public KsError(ErrorCode errorCode, String property, String errorDescription) {
        this.property = property;
        this.errorCode = errorCode != null ? errorCode.name() : ErrorCode.FIELD_INVALID.name();
        this.errorDescription = errorDescription;
    }

    public KsError(ErrorCode errorCode, String errorDescription) {
        this.errorCode = errorCode.name();
        this.errorDescription = errorDescription;
    }

    public static KsError of(Error error, String recordId, String recordNumber, String recordType) {
        return new KsError(recordId, recordNumber, recordType, error.getErrorCode(), error.getText());
    }

    public static KsError of(Error error) {
        return new KsError(error.getErrorCode(), error.getProperty(), error.getText());
    }

    public static List<KsError> of(List<Error> errors) {
        return errors.stream().map(error -> KsError.of(error)).collect(Collectors.toList());
    }

    public static List<Error> convertToError(List<KsError> errors) {
        return errors.stream().map(error -> KsError.convertToError(error)).collect(Collectors.toList());
    }

    public static Error convertToError(KsError error) {
        return new Error(error.property, error.getErrorCode() != null ? ErrorCode.valueOf(error.errorCode) : ErrorCode.FIELD_INVALID, error.errorDescription);
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(String recordNumber) {
        this.recordNumber = recordNumber;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

