/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.registration;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import org.springframework.beans.BeanUtils;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.esf.model.JsonViews;
import ru.uss.esf.model.dictionary.Taxpayer;
import ru.uss.esf.model.registration.ProjectParticipantType;
import ru.uss.esf.model.registration.ProjectType;
import ru.uss.esf.model.registration.SignData;
import ru.uss.esf.validation.common.field.Tin;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectParticipant
implements Serializable {
    @JsonIgnore
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private Long projectId;
    @JsonView(value={JsonViews.Participant.class})
    @Documentation(value="\u0422\u0438\u043f \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430")
    private ProjectParticipantType type;
    @JsonView(value={JsonViews.Participant.class})
    @Documentation(value="\u0422\u0418\u041d \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430")
    @NotNull(message="{participant.tin.notNull}")
    @Tin(message="{participant.tin.format}")
    private @NotNull(message="{participant.tin.notNull}") String tin;
    @JsonView(value={JsonViews.Participant.class})
    @Documentation(value="\u0414\u0435\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0438, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0435 \u0438\u0437 \u0415\u0425\u0414")
    private Taxpayer taxpayer;
    @JsonView(value={JsonViews.Participant.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0447\u0430\u0441\u0442\u0438\u044f \u0432 \u043f\u0440\u043e\u0435\u043a\u0442\u0435")
    private Date startDate;
    @JsonView(value={JsonViews.Participant.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0443\u0447\u0430\u0441\u0442\u0438\u044f \u0432 \u043f\u0440\u043e\u0435\u043a\u0442\u0435")
    private Date endDate;
    @JsonView(value={JsonViews.Participant.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Documentation(value="\u0414\u043e\u043b\u044f \u0443\u0447\u0430\u0441\u0442\u0438\u044f")
    @NotNull(message="{participant.shareParticipation.notNull}", groups={ProjectType.OperatorContractor.class, ProjectType.OperatorContractorJointActivityAgreement.class})
    @PositiveNumber(message="{participant.shareParticipation.positive}", groups={ProjectType.OperatorContractor.class})
    @Digits(integer=12, fraction=6, message="{participant.shareParticipation.digits}")
    private @NotNull(message="{participant.shareParticipation.notNull}", groups={ProjectType.OperatorContractor.class, ProjectType.OperatorContractorJointActivityAgreement.class}) @Digits(integer=12, fraction=6, message="{participant.shareParticipation.digits}") BigDecimal shareParticipation;
    @JsonView(value={JsonViews.Participant.class})
    @Documentation(value="\u0423\u0447\u0435\u0442 \u0434\u0435\u043b\u044c\u0442\u044b \u043f\u0440\u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u043d\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439")
    private Boolean hasDelta;
    @JsonView(value={JsonViews.Participant.class})
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u042d\u0426\u041f \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private SignData activationSign = new SignData();
    @JsonView(value={JsonViews.Participant.class})
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u042d\u0426\u041f \u043f\u0440\u0438 \u043f\u0440\u0438\u043a\u0440\u0430\u0449\u0435\u043d\u0438\u0438 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private SignData terminationSign = new SignData();
    @JsonView(value={JsonViews.Participant.class})
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy HH:mm:ss.SSS")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430")
    private Date inputDate = new Date();

    public ProjectParticipant() {
    }

    public ProjectParticipant(String tin, ProjectParticipantType type, BigDecimal shareParticipation) {
        this.tin = tin;
        this.type = type;
        this.shareParticipation = shareParticipation;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public ProjectParticipantType getType() {
        return this.type;
    }

    public void setType(ProjectParticipantType type) {
        this.type = type;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public Taxpayer getTaxpayer() {
        return this.taxpayer;
    }

    public void setTaxpayer(Taxpayer taxpayer) {
        this.taxpayer = taxpayer;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getShareParticipation() {
        return this.shareParticipation;
    }

    public void setShareParticipation(BigDecimal shareParticipation) {
        this.shareParticipation = shareParticipation;
    }

    public Boolean getHasDelta() {
        return this.hasDelta;
    }

    public void setHasDelta(Boolean hasDelta) {
        this.hasDelta = hasDelta;
    }

    public SignData getActivationSign() {
        return this.activationSign;
    }

    public void setActivationSign(SignData activationSign) {
        this.activationSign = activationSign;
    }

    public SignData getTerminationSign() {
        return this.terminationSign;
    }

    public void setTerminationSign(SignData terminationSign) {
        this.terminationSign = terminationSign;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public boolean isAttorney() {
        return this.type == ProjectParticipantType.ATTORNEY;
    }

    public boolean isTruster() {
        return this.type == ProjectParticipantType.TRUSTER;
    }

    public boolean isOperator() {
        return this.type == ProjectParticipantType.OPERATOR;
    }

    public boolean isContractor() {
        return this.type == ProjectParticipantType.CONTRACTOR;
    }

    public boolean isManager() {
        return this.isAttorney() || this.isOperator();
    }

    public boolean isOwner() {
        return this.isTruster() || this.isContractor();
    }

    public static ProjectParticipant newAttorney(String initiatorTin) {
        return new ProjectParticipant(initiatorTin, ProjectParticipantType.ATTORNEY, null);
    }

    public static ProjectParticipant newTruster(String initiatorTin) {
        return new ProjectParticipant(initiatorTin, ProjectParticipantType.TRUSTER, null);
    }

    public static ProjectParticipant newOperator(String initiatorTin) {
        return new ProjectParticipant(initiatorTin, ProjectParticipantType.OPERATOR, null);
    }

    public static ProjectParticipant newContractor(String initiatorTin, BigDecimal shareParticipation) {
        return new ProjectParticipant(initiatorTin, ProjectParticipantType.CONTRACTOR, shareParticipation);
    }

    public static ProjectParticipant newVersion(ProjectParticipant participant) {
        ProjectParticipant result = new ProjectParticipant();
        BeanUtils.copyProperties((Object)participant, (Object)result, (String[])new String[]{"projectId"});
        return result;
    }
}

