/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.registration;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlType;
import ru.uss.esf.model.dictionary.EnterpriseType;
import ru.uss.esf.model.dictionary.TaxpayerRegistration;
import ru.uss.esf.model.usermng.BusinessProfileType;

@XmlType(name="RegistrationType")
@Documentation(value="\u0422\u0438\u043f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041d\u041f \u0432 \u0418\u0421 \u042d\u0421\u0424")
public enum RegistrationType {
    ENTERPRISE,
    ENTREPRENEUR,
    INDIVIDUAL,
    LAWYER,
    BAILIFF,
    MEDIATOR,
    NOTARY;


    public static RegistrationType resolve(EnterpriseType type) {
        RegistrationType registrationType;
        switch (type) {
            case INDIVIDUAL: {
                registrationType = INDIVIDUAL;
                break;
            }
            case INDIVIDUAL_ENTREPRENEUR: {
                registrationType = ENTREPRENEUR;
                break;
            }
            default: {
                registrationType = ENTERPRISE;
            }
        }
        return registrationType;
    }

    public static RegistrationType resolve(TaxpayerRegistration.Type type) {
        RegistrationType registrationType = null;
        switch (type) {
            case LAWYER: {
                registrationType = LAWYER;
                break;
            }
            case BAILIFF: {
                registrationType = BAILIFF;
                break;
            }
            case MEDIATOR: {
                registrationType = MEDIATOR;
                break;
            }
            case NOTARY: {
                registrationType = NOTARY;
                break;
            }
            case INDIVIDUAL_ENTREPRENEUR: {
                registrationType = ENTREPRENEUR;
            }
        }
        return registrationType;
    }

    public static RegistrationType resolve(BusinessProfileType businessProfileType, EnterpriseType enterpriseType) {
        RegistrationType result = null;
        switch (businessProfileType) {
            case LAWYER: {
                result = LAWYER;
                break;
            }
            case BAILIFF: {
                result = BAILIFF;
                break;
            }
            case MEDIATOR: {
                result = MEDIATOR;
                break;
            }
            case NOTARY: {
                result = NOTARY;
            }
        }
        return result != null ? result : RegistrationType.resolve(enterpriseType);
    }
}

