/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.abstractsnt;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.ValidationGroupsAware;
import ru.uss.core.utils.EsfCollectionUtils;
import ru.uss.core.validation.common.FutureOrCurrentDate;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.IsNull;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.esf.model.snt.SntAdditionalStatus;
import ru.uss.esf.model.snt.SntParticipantType;
import ru.uss.esf.model.snt.SntValidationGroups;
import ru.uss.esf.model.snt.SntVersion;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProduct;
import ru.uss.esf.model.snt.abstractsnt.SntAbstractProductSet;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.validation.common.field.Text;

@XmlRootElement(name="snt")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractSnt")
@Documentation(value="\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0421\u041d\u0422 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 \u0421\u041d\u0422 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435")
@JsonIgnoreProperties(value={"@class"})
public abstract class AbstractSnt
implements Serializable,
ValidationGroupsAware {
    @IsNotNull(fieldPath="abstractSnt.sntType")
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u0421\u041d\u0422")
    private SntType sntType;
    @Text(min=1, max=30, message="{abstractSnt.number.size}")
    @IsNotNull(fieldPath="abstractSnt.number")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0421\u041d\u0422 \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b (A 1)")
    private String number;
    @FutureOrCurrentDate(fieldPath="abstractSnt.date")
    @IsNotNull(fieldPath="abstractSnt.date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u0421\u041d\u0422 (A 2)")
    private Date date;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u0442\u0433\u0440\u0443\u0437\u043a\u0438 \u0442\u043e\u0432\u0430\u0440\u0430 (A 3)")
    private Date shippingDate;
    @IsNotNull(message="{abstractSnt.fixedOrReturn.relatedRegistrationNumber.notNull}", groups={SntValidationGroups.FixedSnt.class, SntValidationGroups.ReturnedSnt.class})
    @IsNull(message="{abstractSnt.primary.relatedRegistrationNumber.mustBeNull}", groups={SntValidationGroups.PrimarySnt.class})
    @RequiredString(required=false, minLen=42, maxLen=42, fieldPath="abstractSnt.relatedRegistrationNumber")
    @XmlElement(required=false)
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 (\u0438\u0441\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0439, \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442) \u0421\u041d\u0422 \u0432 \u0418\u0421 \u042d\u0421\u0424 (A 5.1, A 6.1)")
    private String relatedRegistrationNumber;
    @XmlTransient
    private SntAdditionalStatus additionalStatus;
    @XmlTransient
    protected String creatorTin;
    @XmlTransient
    private Long creatorProjectCode;

    public void setCreatorTin(String creatorTin) {
        this.creatorTin = creatorTin;
    }

    public Long getCreatorProjectCode() {
        return this.creatorProjectCode;
    }

    public void setCreatorProjectCode(Long creatorProjectCode) {
        this.creatorProjectCode = creatorProjectCode;
    }

    public SntType getSntType() {
        return this.sntType;
    }

    public void setSntType(SntType sntType) {
        this.sntType = sntType;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getRelatedRegistrationNumber() {
        return this.relatedRegistrationNumber;
    }

    public void setRelatedRegistrationNumber(String relatedRegistrationNumber) {
        this.relatedRegistrationNumber = relatedRegistrationNumber;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getShippingDate() {
        return this.shippingDate;
    }

    public void setShippingDate(Date shippingDate) {
        this.shippingDate = shippingDate;
    }

    @JsonProperty(value="version")
    @XmlTransient
    public abstract SntVersion getVersion();

    public abstract String getCreatorTin();

    public abstract SntParticipantType getCreatorType();

    public abstract List<String> getRecipientTinList();

    public abstract List<String> getRecipientBranchTinList();

    public abstract List<String> getSenderTinList();

    public abstract List<String> getSenderBranchTinList();

    public abstract Set<String> getTnvedCodeSet();

    public abstract String getCreatorKogd();

    public abstract String getCustomerTin();

    public abstract String getCustomerBranchTin();

    public abstract Set<String> getCustomerParticipantTins();

    public abstract String getSellerTin();

    public abstract String getSellerBranchTin();

    public abstract Set<String> getSellerParticipantTins();

    public abstract List<? extends SntAbstractProductSet> getProductSets();

    public abstract List<? extends SntAbstractProduct> getProducts();

    public abstract boolean isCustomerIndividual();

    public abstract boolean isEsfRequired();

    public abstract String confirmerTin();

    public abstract boolean isCustomerRetail();

    public abstract boolean isSellerRetail();

    public abstract boolean isCustomerRetailer();

    public abstract boolean isSellerRetailer();

    public abstract boolean isCustomerSmallRetailOutlet();

    @JsonIgnore
    public abstract boolean hasExportControlProducts();

    public SntAdditionalStatus getAdditionalStatus() {
        return this.additionalStatus;
    }

    public void setAdditionalStatus(SntAdditionalStatus additionalStatus) {
        this.additionalStatus = additionalStatus;
    }

    public abstract DocumentParticipantType getSellerType();

    public abstract DocumentParticipantType getCustomerType();

    public abstract boolean hasExciseSections();

    public abstract Long getSellerStoreId();

    public abstract Long getCustomerStoreId();

    public abstract boolean isTransferOnePersonInKz();

    public Set<String> getParticipantTinSet() {
        HashSet<String> participantSet = new HashSet<String>();
        EsfCollectionUtils.nullSafeAddAll(participantSet, this.getSenderTinList());
        EsfCollectionUtils.nullSafeAddAll(participantSet, this.getRecipientTinList());
        return participantSet;
    }

    public Set<String> getSenderAndBranchTins() {
        HashSet<String> tins = new HashSet<String>();
        EsfCollectionUtils.nullSafeAddAll(tins, this.getSenderTinList());
        EsfCollectionUtils.nullSafeAddAll(tins, this.getSenderBranchTinList());
        return tins;
    }

    public Set<String> getRecipientAndBranchTins() {
        HashSet<String> tins = new HashSet<String>();
        EsfCollectionUtils.nullSafeAddAll(tins, this.getRecipientTinList());
        EsfCollectionUtils.nullSafeAddAll(tins, this.getRecipientBranchTinList());
        return tins;
    }

    @XmlTransient
    @JsonIgnore
    public abstract Long getSellerProjectCode();

    @XmlTransient
    @JsonIgnore
    public abstract Long getCustomerProjectCode();

    @XmlTransient
    @JsonIgnore
    public abstract List<String> getSellerProjectParticipantTinList();

    @XmlTransient
    @JsonIgnore
    public abstract List<String> getCustomerProjectParticipantTinList();

    @XmlTransient
    @JsonIgnore
    public abstract boolean isLeasing();

    @JsonIgnore
    public abstract boolean hasFinalUserMark();

    @JsonIgnore
    public abstract boolean hasTransferExportImport();

    @JsonIgnore
    public abstract boolean hasExportType();

    @JsonIgnore
    @XmlTransient
    public abstract BigDecimal getTotalSumWithoutTax();

    @JsonIgnore
    public Date getTnvedCheckDate() {
        if (this.shippingDate != null) {
            return this.shippingDate;
        }
        return this.date;
    }

    @XmlTransient
    @JsonIgnore
    public abstract boolean isSellerLessor();

    @XmlTransient
    @JsonIgnore
    public abstract boolean isCustomerLessor();

    public abstract BigDecimal getCurrencyRate();
}

