/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.builder;

import java.util.Date;
import java.util.List;
import ru.uss.core.model.Error;
import ru.uss.core.model.SignatureType;
import ru.uss.esf.model.snt.SntDocumentInfo;
import ru.uss.esf.model.snt.abstractsnt.AbstractSnt;

public class SntDocumentInfoBuilder {
    private SntDocumentInfo documentInfo = new SntDocumentInfo();

    private SntDocumentInfoBuilder() {
    }

    public SntDocumentInfoBuilder setSntId(Long sntId) {
        this.documentInfo.setSntId(sntId);
        return this;
    }

    public SntDocumentInfoBuilder setInputDate(Date inputDate) {
        this.documentInfo.setInputDate(inputDate);
        return this;
    }

    public SntDocumentInfoBuilder setInputAsNow() {
        this.documentInfo.setInputDate(new Date());
        return this;
    }

    public SntDocumentInfoBuilder setSntBody(String sntBody) {
        this.documentInfo.setSntBody(sntBody);
        return this;
    }

    public SntDocumentInfoBuilder setCreatorLogin(String creatorLogin) {
        this.documentInfo.setCreatorLogin(creatorLogin);
        return this;
    }

    public SntDocumentInfoBuilder setCreatorTin(String creatorTin) {
        this.documentInfo.setCreatorTin(creatorTin);
        return this;
    }

    public SntDocumentInfoBuilder setCreatorProjectCode(Long creatorProjectCode) {
        this.documentInfo.setCreatorProjectCode(creatorProjectCode);
        return this;
    }

    public SntDocumentInfoBuilder setSignature(String signature) {
        this.documentInfo.setSignature(signature);
        return this;
    }

    public SntDocumentInfoBuilder setSignatureType(SignatureType signatureType) {
        this.documentInfo.setSignatureType(signatureType);
        return this;
    }

    public SntDocumentInfoBuilder setCertificate(String certificate) {
        this.documentInfo.setCertificate(certificate);
        return this;
    }

    public SntDocumentInfoBuilder setSignatureValid(boolean signatureValid) {
        this.documentInfo.setSignatureValid(signatureValid);
        return this;
    }

    public SntDocumentInfoBuilder setSnt(AbstractSnt snt) {
        this.documentInfo.setSnt(snt);
        return this;
    }

    public SntDocumentInfoBuilder setErrors(List<Error> errors) {
        this.documentInfo.setErrors(errors);
        return this;
    }

    public SntDocumentInfo build() {
        return this.documentInfo;
    }

    public static SntDocumentInfoBuilder create() {
        return new SntDocumentInfoBuilder();
    }
}

