/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.matching.fno;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.validation.fno.DocumentFnoRegistrationNumberCorrect;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SourceProduct")
@Documentation(value="\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0442\u043e\u0432\u0430\u0440\u0435 \u0434\u043b\u044f \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0435\u0439 \u0432 \u0424\u041d\u041e 328")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SourceProduct {
    @NotNull(message="{fnoMatching.sourceDocument.product.idx}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 \u0421\u041d\u0422")
    private @NotNull(message="{fnoMatching.sourceDocument.product.idx}") String idx;
    @RequiredString(required=true, minLen=1, maxLen=2500, fieldPath="fnoMatching.sourceDocument.product.name")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430")
    private String name;
    @RequiredString(required=true, minLen=10, maxLen=10, fieldPath="fnoMatching.sourceDocument.product.tnvedCode")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0422\u041d\u0432\u042d\u0414")
    private String tnvedCode;
    @RequiredString(required=true, minLen=1, maxLen=12, fieldPath="fnoMatching.sourceDocument.product.measureUnitCode")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private String measureUnitCode;
    @PositiveNumber(fieldPath="fnoMatching.sourceDocument.product.quantity")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=6, fieldPath="fnoMatching.sourceDocument.product.quantity")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u0430")
    private BigDecimal quantity;
    @PositiveNumber(fieldPath="fnoMatching.sourceDocument.product.price")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=3, fieldPath="fnoMatching.sourceDocument.product.price")
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430")
    private BigDecimal price;
    @DocumentFnoRegistrationNumberCorrect
    @NotNull(message="{fnoMatching.sourceDocument.product.fnoNumber}")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0424\u041d\u041e 328")
    private @NotNull(message="{fnoMatching.sourceDocument.product.fnoNumber}") String fnoNumber;
    @NotNull(message="{fnoMatching.sourceDocument.product.fnoProductNumber}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 \u0424\u041d\u041e 328")
    private @NotNull(message="{fnoMatching.sourceDocument.product.fnoProductNumber}") Integer fnoProductNumber;
    @XmlTransient
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043e\u0431\u043e\u0437\u043d\u0430\u0447\u0430\u044e\u0449\u0438\u0439 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u0434\u0430 \u0422\u041d\u0412\u042d\u0414 \u043d\u0430 WEB \u0435\u0441\u043b\u0438 \u043e\u043d \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0435\u043c\u043d\u0438\u043a\u0430 \u0438\u043b\u0438 \u0437\u0430\u043a\u0440\u044b\u0442")
    private boolean allowTnvedCodeEdit;

    public String getIdx() {
        return this.idx;
    }

    public void setIdx(String idx) {
        this.idx = idx;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTnvedCode() {
        return this.tnvedCode;
    }

    public void setTnvedCode(String tnvedCode) {
        this.tnvedCode = tnvedCode;
    }

    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getFnoNumber() {
        return this.fnoNumber;
    }

    public void setFnoNumber(String fnoNumber) {
        this.fnoNumber = fnoNumber;
    }

    public Integer getFnoProductNumber() {
        return this.fnoProductNumber;
    }

    public void setFnoProductNumber(Integer fnoProductNumber) {
        this.fnoProductNumber = fnoProductNumber;
    }

    public String getFnoNumberKey() {
        return SourceProduct.getFnoNumberKey(this.fnoNumber, String.valueOf(this.fnoProductNumber));
    }

    public static String getFnoNumberKey(String registrationNumber, String productNumber) {
        return registrationNumber + "_" + productNumber;
    }

    public boolean isAllowTnvedCodeEdit() {
        return this.allowTnvedCodeEdit;
    }

    public void setAllowTnvedCodeEdit(boolean allowTnvedCodeEdit) {
        this.allowTnvedCodeEdit = allowTnvedCodeEdit;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof UFormProductV1) {
            UFormProductV1 sntProduct = (UFormProductV1)object;
            return Objects.equals(this.getMeasureUnitCode(), sntProduct.getMeasureUnitCode()) && this.getQuantity() != null && this.getQuantity().compareTo(sntProduct.getQuantity()) == 0 && Objects.equals(this.getTnvedCode(), sntProduct.getTnvedCode());
        }
        if (object instanceof SourceProduct) {
            SourceProduct sntProduct = (SourceProduct)object;
            return Objects.equals(this.getMeasureUnitCode(), sntProduct.getMeasureUnitCode()) && Objects.equals(this.getName(), sntProduct.getName()) && this.getPrice() != null && this.getPrice().compareTo(sntProduct.getPrice()) == 0 && this.getQuantity() != null && this.getQuantity().compareTo(sntProduct.getQuantity()) == 0 && Objects.equals(this.getTnvedCode(), sntProduct.getTnvedCode());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.idx, this.name, this.tnvedCode, this.measureUnitCode, this.quantity, this.price, this.fnoNumber, this.fnoProductNumber);
    }

    public String toString() {
        return "SourceProduct{idx='" + this.idx + '\'' + ", name='" + this.name + '\'' + ", tnvedCode='" + this.tnvedCode + '\'' + ", measureUnitCode='" + this.measureUnitCode + '\'' + ", quantity=" + this.quantity + ", price=" + this.price + ", fnoNumber='" + this.fnoNumber + '\'' + ", fnoProductNumber=" + this.fnoProductNumber + '}';
    }
}

