/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.math.BigDecimal;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.BigDecimalCheck;
import ru.uss.core.validation.common.Gtin;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.PositiveOrZero;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;
import ru.uss.esf.validation.snt.version.v1.SntBearProductCheckV1;

@NotEmptyIfTargetFieldContains.List(value={@NotEmptyIfTargetFieldContains(checkedField="containerCapacity", targetField="measureUnitCode", expectedValues={"778", "868", "881", "991"}, message="{sntAlcoholBeerProductV1.containerCapacity.notNull}")})
@SntBearProductCheckV1
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntAlcoholBeerProduct")
@Documentation(value="\u041f\u0438\u0432\u043e \u0438 \u043f\u0438\u0432\u043d\u044b\u0435 \u043d\u0430\u043f\u0438\u0442\u043a\u0438 (G4)")
public class SntAlcoholBeerProductV1
extends SntBaseProductV1 {
    @RequiredString(required=true, minLen=1, maxLen=2500, fieldPath="sntAlcoholBeerProductV1.productName")
    @XmlElement(required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0438\u0432\u0430 \u0438 \u043f\u0438\u0432\u043d\u044b\u0445 \u043d\u0430\u043f\u0438\u0442\u043a\u043e\u0432 (G4 3)")
    private String productName;
    @RequiredString(required=true, minLen=1, maxLen=450, fieldPath="sntAlcoholBeerProductV1.productionType")
    @XmlElement(required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0412\u0438\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 (G4 4)")
    private String productType;
    @Pattern(regexp="778|868|881|991|112", message="{sntAlcoholBeerProductV1.measureUnitCode.pattern}")
    @RequiredString(required=true, minLen=1, maxLen=12, fieldPath="sntCommonProductV1.measureUnitCode")
    @XmlElement(required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (G4 6)")
    private @Pattern(regexp="778|868|881|991|112", message="{sntAlcoholBeerProductV1.measureUnitCode.pattern}") String measureUnitCode;
    @PositiveNumber(fieldPath="sntAlcoholBeerProductV1.containerCapacity")
    @BigDecimalCheck(nullable=true, maxLeftLen=12, maxRightLen=6, fieldPath="sntAlcoholBeerProductV1.containerCapacity")
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u0415\u043c\u043a\u043e\u0441\u0442\u044c \u0442\u0430\u0440\u044b (\u0432 \u043b\u0438\u0442\u0440\u0430\u0445) (G4 7)")
    private BigDecimal containerCapacity;
    @PositiveNumber(fieldPath="sntAlcoholBeerProductV1.containerCount")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=3, fieldPath="sntAlcoholBeerProductV1.containerCount")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u0431\u0443\u0442\u044b\u043b\u043e\u043a, \u0431\u0430\u043d\u043e\u043a, \u043a\u0435\u0433, \u0443\u043f\u0430\u043a\u043e\u0432\u043e\u043a, \u043b\u0438\u0442\u0440\u043e\u0432)  (G4 8)")
    private BigDecimal containerCount;
    @PositiveNumber(fieldPath="sntAlcoholBeerProductV1.containerCountInPack")
    @BigDecimalCheck(nullable=true, maxLeftLen=12, maxRightLen=0, fieldPath="sntAlcoholBeerProductV1.containerCountInPack")
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e  (\u0431\u0443\u0442\u044b\u043b\u043e\u043a, \u0431\u0430\u043d\u043e\u043a) \u0432 \u0443\u043f\u0430\u043a\u043e\u0432\u043a\u0435 (G4 9)")
    private BigDecimal containerCountInPack;
    @PositiveNumber(fieldPath="sntAlcoholBeerProductV1.quantityInLiters")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=6, fieldPath="sntAlcoholBeerProductV1.quantityInLiters")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u0432 \u043b\u0438\u0442\u0440\u0430\u0445) (G4 10)")
    private BigDecimal quantityInLiters;
    @PositiveOrZero(fieldPath="sntAlcoholBeerProductV1.price")
    @BigDecimalCheck(nullable=false, maxLeftLen=12, maxRightLen=3, fieldPath="sntAlcoholBeerProductV1.price")
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0442\u043e\u0432\u0430\u0440\u0430 (G4 11)")
    private BigDecimal price;
    @Gtin
    @XmlElement(required=false)
    @ImmutableForReturnedSnt
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (GTIN) (G4 20)")
    private String gtinCode;

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.getContainerCount();
    }

    @Override
    public BigDecimal getMatchingQuantity() {
        return this.containerCount;
    }

    @Override
    public String getMatchingMeasureUnitCode() {
        return this.measureUnitCode;
    }

    @Override
    public String getPinCode() {
        return null;
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.BEER;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    @Override
    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public BigDecimal getContainerCapacity() {
        return this.containerCapacity;
    }

    public void setContainerCapacity(BigDecimal containerCapacity) {
        this.containerCapacity = containerCapacity;
    }

    public BigDecimal getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(BigDecimal containerCount) {
        this.containerCount = containerCount;
    }

    public BigDecimal getContainerCountInPack() {
        return this.containerCountInPack;
    }

    public void setContainerCountInPack(BigDecimal containerCountInPack) {
        this.containerCountInPack = containerCountInPack;
    }

    public BigDecimal getQuantityInLiters() {
        return this.quantityInLiters;
    }

    public void setQuantityInLiters(BigDecimal quantityInLiters) {
        this.quantityInLiters = quantityInLiters;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Override
    public String getMarkingCode() {
        return this.gtinCode;
    }

    public String getGtinCode() {
        return this.gtinCode;
    }

    public void setGtinCode(String gtinCode) {
        this.gtinCode = gtinCode;
    }

    public BigDecimal getTotalContainerCount() {
        if (this.containerCountInPack == null) {
            return this.containerCount;
        }
        if (this.containerCount == null) {
            return null;
        }
        return this.containerCountInPack.multiply(this.containerCount);
    }

    @Override
    public BigDecimal getCertQuantity() {
        return this.containerCount;
    }
}

