/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.snt.version.v1;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.snt.SntValidationGroups;
import ru.uss.esf.model.snt.version.v1.SntBaseProductSetV1;
import ru.uss.esf.model.snt.version.v1.SntEthanolProductV1;
import ru.uss.esf.model.snt.version.v1.SntProductTypeV1;
import ru.uss.esf.validation.snt.ImmutableForReturnedSnt;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SntEthanolProductSet")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u044d\u0442\u0438\u043b\u043e\u0432\u043e\u043c\u0443 \u0441\u043f\u0438\u0440\u0442\u0443 (G2)")
public class SntEthanolProductSetV1
extends SntBaseProductSetV1 {
    @XmlTransient
    public static final String OPERATION_CODE_ALCOHOL_PRODUCT_NEEDS = "1";
    @XmlTransient
    public static final String OPERATION_CODE_MEDICAL_NEEDS = "2";
    @XmlTransient
    public static final String OPERATION_CODE_TECHNICAL_NEEDS = "3";
    @XmlTransient
    public static final String OPERATION_CODE_BAIKONUR_SHIPPING_ETHANOL = "15";
    @XmlTransient
    public static final String OPERATION_CODE_FINAL_END_USER = "22";
    @Pattern(regexp="1|2|3|15", message="{sntEthanolProductSetV1.operationCode.pattern}")
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="sntEthanolProductSetV1.operationCode", groups={SntValidationGroups.ReturnedSnt.class})
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 (G2 57)")
    private @Pattern(regexp="1|2|3|15", message="{sntEthanolProductSetV1.operationCode.pattern}") String operationCode;
    @Valid
    @XmlElementWrapper(name="products", required=true)
    @XmlElement(name="product", required=true)
    @ImmutableForReturnedSnt
    @Documentation(value="\u042d\u0442\u0438\u043b\u043e\u0432\u044b\u0439 \u0441\u043f\u0438\u0440\u0442 (G2)")
    private List<SntEthanolProductV1> products;

    @Override
    public String getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(String operationCode) {
        this.operationCode = operationCode;
    }

    public List<SntEthanolProductV1> getProducts() {
        return this.products;
    }

    public void setProducts(List<SntEthanolProductV1> products) {
        this.products = products;
    }

    @Override
    public boolean isBaikonurShipping() {
        return OPERATION_CODE_BAIKONUR_SHIPPING_ETHANOL.equals(this.getOperationCode());
    }

    @Override
    public boolean isMedicalNeeds() {
        return OPERATION_CODE_MEDICAL_NEEDS.equals(this.getOperationCode());
    }

    @Override
    public boolean isTechnicalNeeds() {
        return OPERATION_CODE_TECHNICAL_NEEDS.equals(this.getOperationCode());
    }

    @Override
    public SntProductTypeV1 getSntProductType() {
        return SntProductTypeV1.ETHANOL;
    }

    @Override
    public boolean isExciseProducts() {
        return true;
    }
}

