/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.usermng;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import ru.uss.core.utils.LocaleUtils;
import ru.uss.esf.model.blocking.BlockingReason;
import ru.uss.esf.model.dictionary.EnterpriseType;
import ru.uss.esf.model.dictionary.Taxpayer;
import ru.uss.esf.model.registration.ProjectParticipantType;
import ru.uss.esf.model.usermng.BusinessProfileType;
import ru.uss.esf.model.usermng.Permission;
import ru.uss.esf.model.usermng.ProfileType;
import ru.uss.esf.model.usermng.User;
import ru.uss.esf.model.usermng.UserStatusType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessUser")
@Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442-\u0441\u0432\u044f\u0437\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435\u043c \u043e\u0442 \u0438\u043c\u0435\u043d\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043e\u043d \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442")
public class BusinessUser
implements Serializable {
    public static final String INDIVIDUAL_FAKE_PROFILE_ID = "individual";
    @Documentation(value="\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447")
    private String id;
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0438\u043b\u044f, \u0441\u043e\u0441\u0442\u0430\u0432\u043d\u043e\u0435 \u0438\u043c\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 UI \u043f\u0440\u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439")
    private String name;
    @Documentation(value="\u0418\u0418\u041d")
    private String iin;
    @Documentation(value="\u0411\u0418\u041d \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f \u043e\u0442 \u0438\u043c\u0435\u043d\u0438 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043c\u043e\u0436\u0435\u0442 \u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c")
    private String tin;
    @Documentation(value="\u041f\u0440\u0430\u0432\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f")
    private Set<Permission> permissions = new HashSet<Permission>();
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u044e\u0449\u0438\u0439 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f")
    private BusinessProfileType businessProfileType;
    @Documentation(value="\u041e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439")
    private String actsOnTheBasis;
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f")
    private UserStatusType status;
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f")
    private String reason;
    @XmlElement
    private String eventId;
    @XmlTransient
    private Boolean isShow;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0434\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0441\u0442\u0438")
    private Date expirationDate;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0434\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0441\u0442\u0438")
    private Date updateDate;
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0438, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u0430\u044f \u0438\u0437 \u0415\u0425\u0414")
    private Taxpayer enterpriseTaxpayerInfo;
    @Documentation(value="\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044f")
    private ProfileType type;
    @XmlElement
    @Documentation(value="\u0422\u0438\u043f \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private ProjectParticipantType projectParticipantType;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Documentation(value="\u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private Long projectCode;
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private String projectName;
    @Documentation(value="\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f")
    @XmlElement
    private Map<String, String> messages;
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0438\u043b\u0438\u0430\u043b\u043e\u0432")
    private List<BusinessUser> branches = new ArrayList<BusinessUser>();

    public void generateId() {
        this.setId(BusinessUser.generateId(this.iin, this.tin, this.projectCode, this.businessProfileType));
    }

    public static String generateId(String iin, String tin, Long projectCode, BusinessProfileType profileType) {
        return Objects.toString(iin, "") + "-" + Objects.toString(tin, "") + "-" + Objects.toString(projectCode, "") + "-" + Objects.toString((Object)profileType, "");
    }

    public static BusinessUser newIndividualFake(User user, Locale locale) {
        BusinessUser result = BusinessUser.newGeneric(INDIVIDUAL_FAKE_PROFILE_ID, user.getLogin(), user.getLogin(), null, null, BusinessProfileType.INDIVIDUAL, "", ProfileType.GENERAL, null);
        if (user.isRegisteredAsEntrepreneur()) {
            result.setMessages(user.getBusinessEntryForTin(user.getLogin(), BusinessProfileType.ENTREPRENEUR).getMessages());
        }
        result.setName(LocaleUtils.isLocaleRU(locale) ? "\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e" : "\u0416\u0435\u043a\u0435 \u0442\u04b1\u043b\u0493\u0430");
        return result;
    }

    public static BusinessUser newEntrepreneur(String iin) {
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, iin, null, BusinessProfileType.ENTREPRENEUR), iin, iin, null, null, BusinessProfileType.ENTREPRENEUR, EnterpriseType.INDIVIDUAL_ENTREPRENEUR.toString(), ProfileType.GENERAL, null);
    }

    public static BusinessUser newPrivatePractice(String iin, BusinessProfileType businessProfileType) {
        if (!Arrays.asList(BusinessProfileType.LAWYER, BusinessProfileType.BAILIFF, BusinessProfileType.MEDIATOR, BusinessProfileType.NOTARY).contains((Object)businessProfileType)) {
            throw new IllegalArgumentException("invalid businessProfileType for private practice");
        }
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, iin, null, businessProfileType), iin, iin, null, null, businessProfileType, "", ProfileType.GENERAL, null);
    }

    public static BusinessUser newPrivatePracticeUser(String iin, String tin, BusinessProfileType businessProfileType) {
        if (!Arrays.asList(BusinessProfileType.LAWYER_USER, BusinessProfileType.BAILIFF_USER, BusinessProfileType.MEDIATOR_USER, BusinessProfileType.NOTARY_USER).contains((Object)businessProfileType)) {
            throw new IllegalArgumentException("invalid businessProfileType for private practice user");
        }
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, tin, null, businessProfileType), iin, tin, null, null, businessProfileType, "", ProfileType.GENERAL, null);
    }

    public static BusinessProfileType resolvePrivatePracticeUserType(BusinessProfileType profileType) {
        switch (profileType) {
            case LAWYER: {
                return BusinessProfileType.LAWYER_USER;
            }
            case BAILIFF: {
                return BusinessProfileType.BAILIFF_USER;
            }
            case MEDIATOR: {
                return BusinessProfileType.MEDIATOR_USER;
            }
            case NOTARY: {
                return BusinessProfileType.NOTARY_USER;
            }
        }
        throw new IllegalArgumentException("invalid profileType:" + (Object)((Object)profileType));
    }

    public static BusinessUser newEnterprise(String iin, String tin, String actsOnTheBasis) {
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, tin, null, BusinessProfileType.ADMIN_ENTERPRISE), iin, tin, null, null, BusinessProfileType.ADMIN_ENTERPRISE, actsOnTheBasis, ProfileType.GENERAL, null);
    }

    public static BusinessUser newUser(String iin, String tin) {
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, tin, null, BusinessProfileType.USER), iin, tin, null, null, BusinessProfileType.USER, "", ProfileType.GENERAL, null);
    }

    public static BusinessUser newEntrepreneurUser(String iin, String tin) {
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, tin, null, BusinessProfileType.ENTREPRENEUR_USER), iin, tin, null, null, BusinessProfileType.ENTREPRENEUR_USER, "", ProfileType.GENERAL, null);
    }

    public static BusinessUser newProjectUser(String iin, String tin, Long projectCode, String projectName, ProjectParticipantType projectParticipantType) {
        return BusinessUser.newGeneric(BusinessUser.generateId(iin, tin, projectCode, BusinessProfileType.PROJECT_USER), iin, tin, projectCode, projectName, BusinessProfileType.PROJECT_USER, "", ProfileType.PROJECT, projectParticipantType);
    }

    public static BusinessUser newBranchFake(BusinessUser source, String iin, String tin) {
        BusinessUser result = new BusinessUser();
        BeanUtils.copyProperties((Object)source, (Object)result);
        result.setIin(iin);
        result.setTin(tin);
        result.generateId();
        result.setBranches(Collections.emptyList());
        result.setShow(true);
        return result;
    }

    private static BusinessUser newGeneric(String id, String iin, String tin, Long projectCode, String projectName, BusinessProfileType businessProfileType, String actsOnTheBasis, ProfileType profileType, ProjectParticipantType projectParticipantType) {
        BusinessUser result = new BusinessUser();
        result.setId(id);
        result.setIin(iin);
        result.setTin(tin);
        result.setProjectCode(projectCode);
        result.setProjectName(projectName);
        result.setPermissions(new HashSet<Permission>());
        result.setBusinessProfileType(businessProfileType);
        result.setActsOnTheBasis(actsOnTheBasis);
        result.setStatus(UserStatusType.ACTIVE);
        result.setReason("");
        result.setShow(true);
        result.setType(profileType);
        result.setProjectParticipantType(projectParticipantType);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void initName(Locale locale) {
        Taxpayer taxpayer = this.getEnterpriseTaxpayerInfo();
        if (taxpayer != null) {
            String companyName = taxpayer.getPreferableCompanyName(locale);
            if (BlockingReason.LIQUIDATION.equals((Object)taxpayer.getBlockingReason())) {
                companyName = companyName + " (\u041b\u0438\u043a\u0432\u0438\u0434\u0438\u0440\u043e\u0432\u0430\u043d)";
            }
            if (BlockingReason.ENTITY_REORGANIZATION.equals((Object)taxpayer.getBlockingReason()) || BlockingReason.ENTITY_DISINTEGRATION.equals((Object)taxpayer.getBlockingReason())) {
                companyName = companyName + " (\u0420\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d)";
            }
            if (!StringUtils.isBlank((CharSequence)companyName) && !this.isPrivatePractice()) {
                this.setName(companyName);
            } else {
                this.setName(taxpayer.getPreferableUserName(locale) + this.resolvePrivatePracticeNameSuffix(locale));
            }
        }
    }

    private String resolvePrivatePracticeNameSuffix(Locale locale) {
        switch (this.businessProfileType) {
            case NOTARY: {
                return " (\u041d\u043e\u0442\u0430\u0440\u0438\u0443\u0441)";
            }
            case BAILIFF: {
                return " (\u0427\u0430\u0441\u0442\u043d\u044b\u0439 \u0441\u0443\u0434\u0435\u0431\u043d\u044b\u0439 \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c)";
            }
            case MEDIATOR: {
                return " (\u041c\u0435\u0434\u0438\u0430\u0442\u043e\u0440)";
            }
            case LAWYER: {
                return " (\u0410\u0434\u0432\u043e\u043a\u0430\u0442)";
            }
        }
        return "";
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public String getIin() {
        return this.iin;
    }

    public void setIin(String iin) {
        this.iin = iin;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public UserStatusType getStatus() {
        return this.status;
    }

    public void setStatus(UserStatusType status) {
        this.status = status;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Boolean isShow() {
        return this.isShow;
    }

    public Boolean getShow(Boolean show) {
        return this.isShow;
    }

    public void setShow(Boolean show) {
        this.isShow = show;
    }

    public BusinessProfileType getBusinessProfileType() {
        return this.businessProfileType;
    }

    public void setBusinessProfileType(BusinessProfileType businessProfileType) {
        this.businessProfileType = businessProfileType;
    }

    public String getActsOnTheBasis() {
        return this.actsOnTheBasis;
    }

    public void setActsOnTheBasis(String actsOnTheBasis) {
        this.actsOnTheBasis = actsOnTheBasis;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Taxpayer getEnterpriseTaxpayerInfo() {
        return this.enterpriseTaxpayerInfo;
    }

    public void setEnterpriseTaxpayerInfo(Taxpayer enterpriseTaxpayerInfo) {
        this.enterpriseTaxpayerInfo = enterpriseTaxpayerInfo;
    }

    public String getPreferableCompanyName(Locale locale) {
        if (this.enterpriseTaxpayerInfo != null) {
            return this.enterpriseTaxpayerInfo.getPreferableCompanyName(locale);
        }
        return "";
    }

    public List<BusinessUser> getBranches() {
        return this.branches;
    }

    public void setBranches(List<BusinessUser> branches) {
        this.branches = branches;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public ProfileType getType() {
        return this.type;
    }

    public void setType(ProfileType type) {
        this.type = type;
    }

    public ProjectParticipantType getProjectParticipantType() {
        return this.projectParticipantType;
    }

    public void setProjectParticipantType(ProjectParticipantType projectParticipantType) {
        this.projectParticipantType = projectParticipantType;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, String> messages) {
        this.messages = messages;
    }

    public boolean isActive() {
        return this.type == ProfileType.PROJECT || this.status == UserStatusType.ACTIVE && !this.isExpired();
    }

    public boolean isExpired() {
        return this.expirationDate != null && this.expirationDate.before(new Date());
    }

    public boolean isBranch() {
        return this.id != null && Pattern.matches(".+_[0-9]+", this.id);
    }

    public boolean isIndividualProfile() {
        return INDIVIDUAL_FAKE_PROFILE_ID.equals(this.id);
    }

    public boolean isPrivatePractice() {
        return Arrays.asList(BusinessProfileType.LAWYER, BusinessProfileType.BAILIFF, BusinessProfileType.MEDIATOR, BusinessProfileType.NOTARY, BusinessProfileType.LAWYER_USER, BusinessProfileType.BAILIFF_USER, BusinessProfileType.MEDIATOR_USER, BusinessProfileType.NOTARY_USER).contains((Object)this.businessProfileType);
    }

    public boolean isAdminProfile() {
        return BusinessProfileType.isAdmin(this.businessProfileType);
    }

    public boolean isUserProfile() {
        return BusinessProfileType.isUser(this.businessProfileType);
    }

    public boolean isEntrepreneur() {
        return Objects.equals(this.getIin(), this.getTin());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("iin", (Object)this.getIin()).add("tin", (Object)this.getTin()).add("projectCode", (Object)this.getProjectCode()).add("permissions", this.permissions).add("businessProfileType", (Object)this.businessProfileType).add("actsOnTheBasis", (Object)this.actsOnTheBasis).add("status", (Object)this.status).add("reason", (Object)this.reason).add("expirationDate", (Object)this.expirationDate).add("updateDate", (Object)this.updateDate).add("type", (Object)this.type).add("projectParticipantType", (Object)this.projectParticipantType).add("projectName", (Object)this.projectName).add("enterpriseTaxpayerInfo", (Object)this.enterpriseTaxpayerInfo).add("branches", this.branches).toString();
    }
}

