/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.usermng;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum UserServiceRoleType {
    SUPER_ADMIN(1, false, false),
    ADMIN(2, false, true),
    OGD_ADMIN(3, true, true),
    SUPPORT(4, false, false),
    OGD(5, false, true),
    IS_USER(6, false, true),
    CA_USER(7, false, true),
    NSI_ADMIN(8, false, true);

    private static Map<UserServiceRoleType, List<UserServiceRoleType>> hierarchy;
    public static final Map<UserServiceRoleType, List<UserServiceRoleType>> rolesHierarchy;
    private final byte typeId;
    private final boolean ogdRestriction;
    private final boolean checkIpAddress;

    private UserServiceRoleType(byte typeId, boolean ogdRestriction, boolean checkIpAddress) {
        this.typeId = typeId;
        this.ogdRestriction = ogdRestriction;
        this.checkIpAddress = checkIpAddress;
    }

    public static UserServiceRoleType getTypeById(byte typeId) {
        for (UserServiceRoleType type : UserServiceRoleType.values()) {
            if (type.getTypeId() != typeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown service role type Id - " + typeId);
    }

    public byte getTypeId() {
        return this.typeId;
    }

    public List<UserServiceRoleType> getManageableRoles() {
        return hierarchy.get((Object)this);
    }

    public boolean isManaged(UserServiceRoleType role) {
        return this.getManageableRoles().contains((Object)role);
    }

    public boolean isOgdRestriction() {
        return this.ogdRestriction;
    }

    public boolean isCheckIpAddress() {
        return this.checkIpAddress;
    }

    static {
        hierarchy = new HashMap<UserServiceRoleType, List<UserServiceRoleType>>();
        hierarchy.put(SUPER_ADMIN, Arrays.asList(ADMIN, IS_USER, CA_USER, OGD_ADMIN, OGD));
        hierarchy.put(ADMIN, Arrays.asList(CA_USER, OGD_ADMIN, SUPPORT, NSI_ADMIN, OGD));
        hierarchy.put(OGD_ADMIN, Collections.singletonList(OGD));
        hierarchy.put(SUPPORT, Collections.emptyList());
        hierarchy.put(OGD, Collections.emptyList());
        hierarchy.put(IS_USER, Collections.emptyList());
        hierarchy.put(CA_USER, Collections.emptyList());
        hierarchy.put(NSI_ADMIN, Collections.emptyList());
        rolesHierarchy = Collections.unmodifiableMap(hierarchy);
    }
}

