/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.version.v1.AwpBankDetailsV1;
import ru.uss.esf.model.awp.version.v1.AwpV1;
import ru.uss.esf.validation.awp.version.v1.AwpBankDetailsCheckV1;

public class AwpBankDetailsValidatorV1
extends AbstractClassLevelValidator<AwpBankDetailsCheckV1, AwpV1> {
    public void initialize(AwpBankDetailsCheckV1 constraintAnnotation) {
    }

    public boolean isValid(AwpV1 awpV1, ConstraintValidatorContext context) {
        int i;
        boolean isValid = true;
        if (CollectionUtils.isNotEmpty(awpV1.getSenders())) {
            for (i = 0; i < awpV1.getSenders().size(); ++i) {
                isValid &= this.internalValidate(awpV1.getSenders().get(i).getBankDetails(), context, "senders[" + i + "].");
            }
        }
        if (CollectionUtils.isNotEmpty(awpV1.getRecipients())) {
            for (i = 0; i < awpV1.getRecipients().size(); ++i) {
                isValid &= this.internalValidate(awpV1.getRecipients().get(i).getBankDetails(), context, "recipients[" + i + "].");
            }
        }
        return isValid;
    }

    private boolean internalValidate(AwpBankDetailsV1 awpBankDetailsV1, ConstraintValidatorContext context, String fieldPathPrefix) {
        if (awpBankDetailsV1 == null) {
            return true;
        }
        int counter = 0;
        counter += awpBankDetailsV1.getKbe() == null ? -1 : 1;
        counter += StringUtils.isEmpty((CharSequence)awpBankDetailsV1.getIik()) ? -1 : 1;
        counter += StringUtils.isEmpty((CharSequence)awpBankDetailsV1.getBik()) ? -1 : 1;
        if ((counter += StringUtils.isEmpty((CharSequence)awpBankDetailsV1.getBank()) ? -1 : 1) != -4 && counter != 4) {
            if (awpBankDetailsV1.getKbe() == null) {
                this.setupContextWithValidationError(context, fieldPathPrefix + "bankDetails.kbe", this.generateNotNullFieldMessage("bankDetails.kbe"));
            }
            if (StringUtils.isEmpty((CharSequence)awpBankDetailsV1.getIik())) {
                this.setupContextWithValidationError(context, fieldPathPrefix + "bankDetails.iik", this.generateNotNullFieldMessage("bankDetails.iik"));
            }
            if (StringUtils.isEmpty((CharSequence)awpBankDetailsV1.getBik())) {
                this.setupContextWithValidationError(context, fieldPathPrefix + "bankDetails.bik", this.generateNotNullFieldMessage("bankDetails.bik"));
            }
            if (StringUtils.isEmpty((CharSequence)awpBankDetailsV1.getBank())) {
                this.setupContextWithValidationError(context, fieldPathPrefix + "bankDetails.bank", this.generateNotNullFieldMessage("bankDetails.bank"));
            }
            return false;
        }
        return true;
    }
}

