/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.version.v1.AwpRecipientParticipantV1;
import ru.uss.esf.validation.awp.version.v1.RecipientParticipantCheckV1;

public class RecipientParticipantCheckValidatorV1
extends AbstractClassLevelValidator<RecipientParticipantCheckV1, AwpRecipientParticipantV1> {
    public void initialize(RecipientParticipantCheckV1 constraintAnnotation) {
    }

    public boolean isValid(AwpRecipientParticipantV1 value, ConstraintValidatorContext context) {
        if (BooleanUtils.isFalse((Boolean)value.getNonResident())) {
            String tin = value.getTin();
            if (tin == null) {
                return this.setupContextWithValidationError(context, "tin", this.generateNotNullFieldMessage("awp.recipients.tin"));
            }
            if (tin.length() != 12) {
                return this.setupContextWithValidationError(context, "tin", "{awp.recipients.tin.incorrectLength}");
            }
        }
        if (BooleanUtils.isTrue((Boolean)value.getNonResident())) {
            if (value.getRegistrationType() != null) {
                return this.setupContextWithValidationError(context, "nonResident", "{awp.recipients.invalid}");
            }
        } else if (value.getRegistrationType() == null) {
            return this.setupContextWithValidationError(context, "registrationType", this.generateNotNullFieldMessage("awp.recipients.recipientRegistrationType"));
        }
        return true;
    }
}

