/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import java.util.Objects;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.abstractawp.AwpRegistrationType;
import ru.uss.esf.model.awp.version.v1.AwpRecipientParticipantV1;
import ru.uss.esf.validation.awp.version.v1.RecipientSharingParticipantCheckV1;

public class RecipientSharingParticipantCheckValidatorV1
extends AbstractClassLevelValidator<RecipientSharingParticipantCheckV1, AwpRecipientParticipantV1> {
    public void initialize(RecipientSharingParticipantCheckV1 constraintAnnotation) {
    }

    public boolean isValid(AwpRecipientParticipantV1 value, ConstraintValidatorContext context) {
        boolean isValid = true;
        if (value.getRegistrationType() == AwpRegistrationType.SHARING_AGREEMENT_PARTICIPANT || value.getRegistrationType() == AwpRegistrationType.JOINT_ACTIVITY_PARTICIPANT) {
            if (StringUtils.isEmpty((CharSequence)value.getSharingParticipantNumber())) {
                this.setupContextWithValidationError(context, "recipients[0].sharingParticipantNumber", this.generateNotNullFieldMessage("awp.recipients.sharingParticipantNumber"));
                isValid = false;
            }
            if (Objects.isNull(value.getSharingParticipantDate())) {
                this.setupContextWithValidationError(context, "recipients[0].sharingParticipantDate", this.generateNotNullFieldMessage("awp.recipients.sharingParticipantDate"));
                isValid = false;
            }
        }
        return isValid;
    }
}

