/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.awp.version.v1;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.awp.version.v1.AwpWorkV1;
import ru.uss.esf.validation.awp.version.v1.WorkNdsRateCheckV1;

public class WorkNdsRateCheckValidatorV1
extends AbstractClassLevelValidator<WorkNdsRateCheckV1, AwpWorkV1> {
    public void initialize(WorkNdsRateCheckV1 constraintAnnotation) {
    }

    public boolean isValid(AwpWorkV1 value, ConstraintValidatorContext context) {
        BigDecimal multiplyResult;
        if (value.getTurnoverSize() == null || value.getNdsAmount() == null) {
            return true;
        }
        if (value.getNdsRate() == null && !BigDecimal.ZERO.equals(value.getNdsAmount())) {
            return this.setupContextWithValidationError(context, "ndsAmount", "{AWP_WORK_INCORRECT_NDS_AMOUNT}");
        }
        if (value.getNdsRate() != null && (multiplyResult = value.getTurnoverSize().multiply(BigDecimal.valueOf(value.getNdsRate().intValue())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).compareTo(value.getNdsAmount()) != 0) {
            return this.setupContextWithValidationError(context, "ndsAmount", "{awpField.ndsAmount.incorrect}");
        }
        return true;
    }
}

