/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.common.clazz;

import java.math.BigDecimal;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.core.validation.common.FieldUtils;
import ru.uss.esf.validation.common.clazz.SumOf;

public class SumOfValidator
extends AbstractClassLevelValidator<SumOf, Object> {
    private String resultField;
    private String[] multiplyFields;
    private String message;

    public void initialize(SumOf constraintAnnotation) {
        this.resultField = constraintAnnotation.resultField();
        this.multiplyFields = constraintAnnotation.multiplyFields();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        BigDecimal multiplyResult = new BigDecimal(0);
        for (String field : this.multiplyFields) {
            multiplyResult = multiplyResult.add(this.getFieldValue(value, field));
        }
        if (multiplyResult.compareTo(this.getFieldValue(value, this.resultField)) != 0) {
            return this.setupContextWithValidationError(context, this.message);
        }
        return true;
    }

    private BigDecimal getFieldValue(Object object, String fieldName) {
        Object value = FieldUtils.getFieldValue(object, fieldName);
        return value == null ? BigDecimal.ZERO : (BigDecimal)value;
    }
}

